/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipUtil;
import org.fife.ui.rtextarea.ClipboardHistory;
import org.fife.ui.rtextarea.ConfigurableCaret;
import org.fife.ui.rtextarea.RTextArea;

class ClipboardHistoryPopup
extends JWindow {
    private RTextArea textArea;
    private ChoiceList list;
    private transient Listener listener;
    private boolean prevCaretAlwaysVisible;
    private static final int VERTICAL_SPACE = 1;
    private static final String MSG = "org.fife.ui.rtextarea.RTextArea";

    ClipboardHistoryPopup(Window parent, RTextArea textArea) {
        super(parent);
        this.textArea = textArea;
        JPanel cp2 = new JPanel(new BorderLayout());
        cp2.setBorder(BorderFactory.createCompoundBorder(TipUtil.getToolTipBorder(), BorderFactory.createEmptyBorder(2, 5, 5, 5)));
        cp2.setBackground(TipUtil.getToolTipBackground());
        this.setContentPane(cp2);
        ResourceBundle msg = ResourceBundle.getBundle(MSG);
        JLabel title = new JLabel(msg.getString("Action.ClipboardHistory.Popup.Label"));
        cp2.add((Component)title, "North");
        this.list = new ChoiceList();
        JScrollPane sp2 = new JScrollPane(this.list);
        sp2.setHorizontalScrollBarPolicy(31);
        cp2.add(sp2);
        this.installKeyBindings();
        this.listener = new Listener();
        this.setLocation();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (size != null) {
            size.width = Math.min(size.width, 300);
            size.width = Math.max(size.width, 200);
        }
        return size;
    }

    private void insertSelectedItem() {
        LabelValuePair lvp = (LabelValuePair)this.list.getSelectedValue();
        if (lvp != null) {
            this.listener.uninstallAndHide();
            String text = lvp.value;
            this.textArea.replaceSelection(text);
            ClipboardHistory.get().add(text);
        }
    }

    private void installKeyBindings() {
        InputMap im2 = this.getRootPane().getInputMap(1);
        ActionMap am10 = this.getRootPane().getActionMap();
        KeyStroke escapeKS = KeyStroke.getKeyStroke(27, 0);
        im2.put(escapeKS, "onEscape");
        am10.put("onEscape", new EscapeAction());
        this.list.getInputMap().remove(escapeKS);
    }

    public void setContents(List<String> contents) {
        this.list.setContents(contents);
        this.pack();
    }

    private void setLocation() {
        Rectangle r10;
        try {
            r10 = this.textArea.modelToView(this.textArea.getCaretPosition());
        }
        catch (Exception e10) {
            e10.printStackTrace();
            return;
        }
        Point p10 = r10.getLocation();
        SwingUtilities.convertPointToScreen(p10, this.textArea);
        r10.x = p10.x;
        r10.y = p10.y;
        Rectangle screenBounds = TipUtil.getScreenBoundsForPoint(r10.x, r10.y);
        int totalH = this.getHeight();
        int y10 = r10.y + r10.height + 1;
        if (y10 + totalH > screenBounds.height) {
            y10 = r10.y - 1 - this.getHeight();
        }
        int x10 = r10.x;
        if (!this.textArea.getComponentOrientation().isLeftToRight()) {
            x10 -= this.getWidth();
        }
        if (x10 < screenBounds.x) {
            x10 = screenBounds.x;
        } else if (x10 + this.getWidth() > screenBounds.x + screenBounds.width) {
            x10 = screenBounds.x + screenBounds.width - this.getWidth();
        }
        this.setLocation(x10, y10);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.list.getModel().getSize() == 0) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.textArea);
            return;
        }
        super.setVisible(visible);
        this.updateTextAreaCaret(visible);
        if (visible) {
            SwingUtilities.invokeLater(() -> {
                this.requestFocus();
                if (this.list.getModel().getSize() > 0) {
                    this.list.setSelectedIndex(0);
                }
                this.list.requestFocusInWindow();
            });
        }
    }

    private void updateTextAreaCaret(boolean visible) {
        Caret caret = this.textArea.getCaret();
        if (caret instanceof ConfigurableCaret) {
            ConfigurableCaret cc2 = (ConfigurableCaret)caret;
            if (visible) {
                this.prevCaretAlwaysVisible = cc2.isAlwaysVisible();
                cc2.setAlwaysVisible(true);
            } else {
                cc2.setAlwaysVisible(this.prevCaretAlwaysVisible);
            }
        }
    }

    private static final class ChoiceList
    extends JList<LabelValuePair> {
        private ChoiceList() {
            super(new DefaultListModel());
            this.setSelectionMode(0);
            this.installKeyboardActions();
        }

        private void installKeyboardActions() {
            InputMap im2 = this.getInputMap();
            ActionMap am10 = this.getActionMap();
            im2.put(KeyStroke.getKeyStroke(40, 0), "onDown");
            am10.put("onDown", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e10) {
                    int index = (this.getSelectedIndex() + 1) % this.getModel().getSize();
                    this.ensureIndexIsVisible(index);
                    this.setSelectedIndex(index);
                }
            });
            im2.put(KeyStroke.getKeyStroke(38, 0), "onUp");
            am10.put("onUp", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e10) {
                    int index = this.getSelectedIndex() - 1;
                    if (index < 0) {
                        index += this.getModel().getSize();
                    }
                    this.ensureIndexIsVisible(index);
                    this.setSelectedIndex(index);
                }
            });
        }

        private void setContents(List<String> contents) {
            DefaultListModel model = (DefaultListModel)this.getModel();
            model.clear();
            for (String str : contents) {
                model.addElement(new LabelValuePair(str));
            }
            this.setVisibleRowCount(Math.min(model.getSize(), 8));
        }
    }

    private class EscapeAction
    extends AbstractAction {
        private EscapeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e10) {
            ClipboardHistoryPopup.this.listener.uninstallAndHide();
        }
    }

    private static class LabelValuePair {
        private String label;
        private String value;
        private static final int LABEL_MAX_LENGTH = 50;

        LabelValuePair(String value) {
            this.label = this.value = value;
            int newline = this.label.indexOf(10);
            boolean multiLine = false;
            if (newline > -1) {
                this.label = this.label.substring(0, newline);
                multiLine = true;
            }
            if (this.label.length() > 50) {
                this.label = String.valueOf(this.label.substring(0, 50)) + "...";
            } else if (multiLine) {
                int toRemove = 3 - (50 - this.label.length());
                if (toRemove > 0) {
                    this.label = this.label.substring(0, this.label.length() - toRemove);
                }
                this.label = String.valueOf(this.label) + "...";
            }
        }

        public String toString() {
            return this.label;
        }
    }

    private class Listener
    extends WindowAdapter
    implements ComponentListener {
        Listener() {
            ClipboardHistoryPopup.this.addWindowFocusListener(this);
            ClipboardHistoryPopup.this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e10) {
                    if (e10.getClickCount() == 2) {
                        ClipboardHistoryPopup.this.insertSelectedItem();
                    }
                }
            });
            ClipboardHistoryPopup.this.list.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "onEnter");
            ClipboardHistoryPopup.this.list.getActionMap().put("onEnter", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e10) {
                    ClipboardHistoryPopup.this.insertSelectedItem();
                }
            });
            Window parent = (Window)ClipboardHistoryPopup.this.getParent();
            parent.addWindowFocusListener(this);
            parent.addWindowListener(this);
            parent.addComponentListener(this);
        }

        @Override
        public void componentResized(ComponentEvent e10) {
            this.uninstallAndHide();
        }

        @Override
        public void componentMoved(ComponentEvent e10) {
            this.uninstallAndHide();
        }

        @Override
        public void componentShown(ComponentEvent e10) {
            this.uninstallAndHide();
        }

        @Override
        public void componentHidden(ComponentEvent e10) {
            this.uninstallAndHide();
        }

        @Override
        public void windowActivated(WindowEvent e10) {
            this.checkForParentWindowEvent(e10);
        }

        @Override
        public void windowLostFocus(WindowEvent e10) {
            if (e10.getSource() == ClipboardHistoryPopup.this) {
                this.uninstallAndHide();
            }
        }

        @Override
        public void windowIconified(WindowEvent e10) {
            this.checkForParentWindowEvent(e10);
        }

        private boolean checkForParentWindowEvent(WindowEvent e10) {
            if (e10.getSource() == ClipboardHistoryPopup.this.getParent()) {
                this.uninstallAndHide();
                return true;
            }
            return false;
        }

        private void uninstallAndHide() {
            Window parent = (Window)ClipboardHistoryPopup.this.getParent();
            parent.removeWindowFocusListener(this);
            parent.removeWindowListener(this);
            parent.removeComponentListener(this);
            ClipboardHistoryPopup.this.removeWindowFocusListener(this);
            ClipboardHistoryPopup.this.setVisible(false);
            ClipboardHistoryPopup.this.dispose();
        }
    }
}

