/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.CaretStyle;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;

public class ConfigurableCaret
extends DefaultCaret {
    private static transient Action selectWord = null;
    private static transient Action selectLine = null;
    private transient MouseEvent selectedWordEvent = null;
    private transient Segment seg = new Segment();
    private CaretStyle style;
    private ChangeableHighlightPainter selectionPainter;
    private boolean alwaysVisible;
    private boolean pasteOnMiddleMouseClick;

    public ConfigurableCaret() {
        this(CaretStyle.THICK_VERTICAL_LINE_STYLE);
    }

    public ConfigurableCaret(CaretStyle style) {
        this.setStyle(style);
        this.selectionPainter = new ChangeableHighlightPainter();
        this.pasteOnMiddleMouseClick = true;
    }

    private void adjustCaret(MouseEvent e10) {
        if ((e10.getModifiers() & 1) != 0 && this.getDot() != -1) {
            this.moveCaret(e10);
        } else {
            this.positionCaret(e10);
        }
    }

    private void adjustFocus(boolean inWindow) {
        RTextArea textArea = this.getTextArea();
        if (textArea != null && textArea.isEnabled() && textArea.isRequestFocusEnabled()) {
            if (inWindow) {
                textArea.requestFocusInWindow();
            } else {
                textArea.requestFocus();
            }
        }
    }

    @Override
    protected synchronized void damage(Rectangle r10) {
        if (r10 != null) {
            this.validateWidth(r10);
            this.x = r10.x - 1;
            this.y = r10.y;
            this.width = r10.width + 4;
            this.height = r10.height;
            this.repaint();
        }
    }

    @Override
    public void deinstall(JTextComponent c10) {
        if (!(c10 instanceof RTextArea)) {
            throw new IllegalArgumentException("c must be instance of RTextArea");
        }
        super.deinstall(c10);
        c10.setNavigationFilter(null);
    }

    public boolean getPasteOnMiddleMouseClick() {
        return this.pasteOnMiddleMouseClick;
    }

    protected RTextArea getTextArea() {
        return (RTextArea)this.getComponent();
    }

    public boolean getRoundedSelectionEdges() {
        return ((ChangeableHighlightPainter)this.getSelectionPainter()).getRoundedEdges();
    }

    @Override
    protected Highlighter.HighlightPainter getSelectionPainter() {
        return this.selectionPainter;
    }

    public CaretStyle getStyle() {
        return this.style;
    }

    @Override
    public void install(JTextComponent c10) {
        if (!(c10 instanceof RTextArea)) {
            throw new IllegalArgumentException("c must be instance of RTextArea");
        }
        super.install(c10);
        c10.setNavigationFilter(new FoldAwareNavigationFilter());
    }

    public boolean isAlwaysVisible() {
        return this.alwaysVisible;
    }

    @Override
    public void mouseClicked(MouseEvent e10) {
        if (!e10.isConsumed()) {
            JTextComponent c10;
            RTextArea textArea = this.getTextArea();
            int nclicks = e10.getClickCount();
            if (SwingUtilities.isLeftMouseButton(e10)) {
                if (nclicks > 2) {
                    switch (nclicks %= 2) {
                        case 0: {
                            this.selectWord(e10);
                            this.selectedWordEvent = null;
                            break;
                        }
                        case 1: {
                            Action a10 = null;
                            ActionMap map = textArea.getActionMap();
                            if (map != null) {
                                a10 = map.get("select-line");
                            }
                            if (a10 == null) {
                                if (selectLine == null) {
                                    selectLine = new RTextAreaEditorKit.SelectLineAction();
                                }
                                a10 = selectLine;
                            }
                            a10.actionPerformed(new ActionEvent(textArea, 1001, null, e10.getWhen(), e10.getModifiers()));
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (SwingUtilities.isMiddleMouseButton(e10) && this.getPasteOnMiddleMouseClick() && nclicks == 1 && textArea.isEditable() && textArea.isEnabled() && (c10 = (JTextComponent)e10.getSource()) != null) {
                try {
                    Toolkit tk2 = c10.getToolkit();
                    Clipboard buffer = tk2.getSystemSelection();
                    if (buffer != null) {
                        Transferable trans;
                        this.adjustCaret(e10);
                        TransferHandler th2 = c10.getTransferHandler();
                        if (th2 != null && (trans = buffer.getContents(null)) != null) {
                            th2.importData(c10, trans);
                        }
                        this.adjustFocus(true);
                    } else {
                        textArea.paste();
                    }
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e10) {
        JTextComponent c10;
        super.mousePressed(e10);
        if (!e10.isConsumed() && SwingUtilities.isRightMouseButton(e10) && (c10 = this.getComponent()) != null && c10.isEnabled() && c10.isRequestFocusEnabled()) {
            c10.requestFocusInWindow();
        }
    }

    @Override
    public void paint(Graphics g10) {
        if (this.isVisible() || this.alwaysVisible) {
            try {
                RTextArea textArea = this.getTextArea();
                g10.setColor(textArea.getCaretColor());
                TextUI mapper = textArea.getUI();
                Rectangle r10 = mapper.modelToView(textArea, this.getDot());
                this.validateWidth(r10);
                if (this.width > 0 && this.height > 0 && !this.contains(r10.x, r10.y, r10.width, r10.height)) {
                    Rectangle clip = g10.getClipBounds();
                    if (clip != null && !clip.contains(this)) {
                        this.repaint();
                    }
                    this.damage(r10);
                }
                r10.height -= 2;
                switch (this.style) {
                    case BLOCK_STYLE: {
                        Color textAreaBg = textArea.getBackground();
                        if (textAreaBg == null) {
                            textAreaBg = Color.white;
                        }
                        g10.setXORMode(textAreaBg);
                        g10.fillRect(r10.x, r10.y, r10.width, r10.height);
                        break;
                    }
                    case BLOCK_BORDER_STYLE: {
                        g10.drawRect(r10.x, r10.y, r10.width - 1, r10.height);
                        break;
                    }
                    case UNDERLINE_STYLE: {
                        Color textAreaBg = textArea.getBackground();
                        if (textAreaBg == null) {
                            textAreaBg = Color.white;
                        }
                        g10.setXORMode(textAreaBg);
                        int y10 = r10.y + r10.height;
                        g10.drawLine(r10.x, y10, r10.x + r10.width - 1, y10);
                        break;
                    }
                    default: {
                        int lineY = r10.y + 1;
                        g10.drawLine(r10.x, lineY, r10.x, lineY + r10.height);
                        break;
                    }
                    case THICK_VERTICAL_LINE_STYLE: {
                        int lineY = r10.y + 1;
                        g10.drawLine(r10.x, lineY, r10.x, lineY + r10.height);
                        ++r10.x;
                        g10.drawLine(r10.x, lineY, r10.x, lineY + r10.height);
                        break;
                    }
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
    }

    private void selectWord(MouseEvent e10) {
        if (this.selectedWordEvent != null && this.selectedWordEvent.getX() == e10.getX() && this.selectedWordEvent.getY() == e10.getY()) {
            return;
        }
        Action a10 = null;
        RTextArea textArea = this.getTextArea();
        ActionMap map = textArea.getActionMap();
        if (map != null) {
            a10 = map.get("select-word");
        }
        if (a10 == null) {
            if (selectWord == null) {
                selectWord = new RTextAreaEditorKit.SelectWordAction();
            }
            a10 = selectWord;
        }
        a10.actionPerformed(new ActionEvent(textArea, 1001, null, e10.getWhen(), e10.getModifiers()));
        this.selectedWordEvent = e10;
    }

    public void setAlwaysVisible(boolean alwaysVisible) {
        if (alwaysVisible != this.alwaysVisible) {
            this.alwaysVisible = alwaysVisible;
            if (!this.isVisible()) {
                this.repaint();
            }
        }
    }

    public void setPasteOnMiddleMouseClick(boolean paste) {
        this.pasteOnMiddleMouseClick = paste;
    }

    public void setRoundedSelectionEdges(boolean rounded) {
        ((ChangeableHighlightPainter)this.getSelectionPainter()).setRoundedEdges(rounded);
    }

    @Override
    public void setSelectionVisible(boolean visible) {
        super.setSelectionVisible(true);
    }

    public void setStyle(CaretStyle style) {
        if (style == null) {
            style = CaretStyle.THICK_VERTICAL_LINE_STYLE;
        }
        if (style != this.style) {
            this.style = style;
            this.repaint();
        }
    }

    private void validateWidth(Rectangle rect) {
        if (rect != null && rect.width <= 1) {
            try {
                RTextArea textArea = this.getTextArea();
                textArea.getDocument().getText(this.getDot(), 1, this.seg);
                Font font = textArea.getFont();
                FontMetrics fm2 = textArea.getFontMetrics(font);
                rect.width = fm2.charWidth(this.seg.array[this.seg.offset]);
                if (rect.width == 0) {
                    rect.width = fm2.charWidth(' ');
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                rect.width = 8;
            }
        }
    }

    private class FoldAwareNavigationFilter
    extends NavigationFilter {
        private FoldAwareNavigationFilter() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setDot(NavigationFilter.FilterBypass fb2, int dot, Position.Bias bias) {
            block11: {
                RSyntaxTextArea rsta;
                RTextArea textArea = ConfigurableCaret.this.getTextArea();
                if (textArea instanceof RSyntaxTextArea && (rsta = (RSyntaxTextArea)ConfigurableCaret.this.getTextArea()).isCodeFoldingEnabled()) {
                    int lastDot = ConfigurableCaret.this.getDot();
                    FoldManager fm2 = rsta.getFoldManager();
                    int line = 0;
                    try {
                        line = textArea.getLineOfOffset(dot);
                    }
                    catch (Exception e10) {
                        e10.printStackTrace();
                    }
                    if (fm2.isLineHidden(line)) {
                        try {
                            if (dot > lastDot) {
                                int lineCount = textArea.getLineCount();
                                while (++line < lineCount && fm2.isLineHidden(line)) {
                                }
                                if (line >= lineCount) {
                                    UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                                    return;
                                }
                                dot = textArea.getLineStartOffset(line);
                                break block11;
                            }
                            if (dot >= lastDot) break block11;
                            while (--line >= 0 && fm2.isLineHidden(line)) {
                            }
                            if (line >= 0) {
                                dot = textArea.getLineEndOffset(line) - 1;
                            }
                        }
                        catch (Exception e11) {
                            e11.printStackTrace();
                            return;
                        }
                    }
                }
            }
            super.setDot(fb2, dot, bias);
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass fb2, int dot, Position.Bias bias) {
            super.moveDot(fb2, dot, bias);
        }
    }
}

