/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;

public class SmartHighlightPainter
extends ChangeableHighlightPainter {
    private Color borderColor;
    private boolean paintBorder;

    public SmartHighlightPainter() {
        super(Color.BLUE);
    }

    public SmartHighlightPainter(Paint paint) {
        super(paint);
    }

    public boolean getPaintBorder() {
        return this.paintBorder;
    }

    @Override
    public Shape paintLayer(Graphics g10, int p02, int p12, Shape viewBounds, JTextComponent c10, View view) {
        g10.setColor((Color)this.getPaint());
        if (p02 == p12) {
            try {
                Shape s10 = view.modelToView(p02, viewBounds, Position.Bias.Forward);
                Rectangle r10 = s10.getBounds();
                g10.drawLine(r10.x, r10.y, r10.x, r10.y + r10.height);
                return r10;
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return null;
            }
        }
        if (p02 == view.getStartOffset() && p12 == view.getEndOffset()) {
            Rectangle alloc = viewBounds instanceof Rectangle ? (Rectangle)viewBounds : viewBounds.getBounds();
            g10.fillRect(alloc.x, alloc.y, alloc.width, alloc.height);
            return alloc;
        }
        try {
            Shape shape = view.modelToView(p02, Position.Bias.Forward, p12, Position.Bias.Backward, viewBounds);
            Rectangle r11 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            g10.fillRect(r11.x, r11.y, r11.width, r11.height);
            if (this.paintBorder) {
                g10.setColor(this.borderColor);
                g10.drawRect(r11.x, r11.y, r11.width - 1, r11.height - 1);
            }
            return r11;
        }
        catch (BadLocationException e10) {
            e10.printStackTrace();
            return null;
        }
    }

    @Override
    public void setPaint(Paint paint) {
        super.setPaint(paint);
        if (paint instanceof Color) {
            this.borderColor = ((Color)paint).darker();
        }
    }

    public void setPaintBorder(boolean paint) {
        this.paintBorder = paint;
    }
}

