/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.VolatileImage;
import org.fife.ui.rtextarea.ImageBackgroundPainterStrategy;
import org.fife.ui.rtextarea.RTextAreaBase;

public class VolatileImageBackgroundPainterStrategy
extends ImageBackgroundPainterStrategy {
    private VolatileImage bgImage;

    public VolatileImageBackgroundPainterStrategy(RTextAreaBase ta2) {
        super(ta2);
    }

    @Override
    protected void paintImage(Graphics g10, int x10, int y10) {
        if (this.bgImage != null) {
            do {
                int rc2;
                if ((rc2 = this.bgImage.validate(null)) == 1) {
                    this.renderImage(this.bgImage.getWidth(), this.bgImage.getHeight(), this.getScalingHint());
                }
                g10.drawImage(this.bgImage, x10, y10, null);
            } while (this.bgImage.contentsLost());
        }
    }

    private void renderImage(int width, int height, int hint) {
        Image master = this.getMasterImage();
        if (master != null) {
            do {
                Image i10 = master.getScaledInstance(width, height, hint);
                this.tracker.addImage(i10, 1);
                try {
                    try {
                        this.tracker.waitForID(1);
                    }
                    catch (InterruptedException e10) {
                        e10.printStackTrace();
                        this.bgImage = null;
                        this.tracker.removeImage(i10, 1);
                        return;
                    }
                }
                finally {
                    this.tracker.removeImage(i10, 1);
                }
                this.bgImage.getGraphics().drawImage(i10, 0, 0, null);
                this.tracker.addImage(this.bgImage, 0);
                try {
                    try {
                        this.tracker.waitForID(0);
                    }
                    catch (InterruptedException e11) {
                        e11.printStackTrace();
                        this.bgImage = null;
                        this.tracker.removeImage(this.bgImage, 0);
                        return;
                    }
                }
                finally {
                    this.tracker.removeImage(this.bgImage, 0);
                }
            } while (this.bgImage.contentsLost());
        } else {
            this.bgImage = null;
        }
    }

    @Override
    protected void rescaleImage(int width, int height, int hint) {
        this.bgImage = this.getRTextAreaBase().createVolatileImage(width, height);
        if (this.bgImage != null) {
            this.renderImage(width, height, hint);
        }
    }
}

