/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import org.jdesktop.animation.timing.interpolation.Interpolator;
import org.jdesktop.animation.timing.interpolation.KeyInterpolators;
import org.jdesktop.animation.timing.interpolation.KeyTimes;
import org.jdesktop.animation.timing.interpolation.KeyValues;

public class KeyFrames {
    private KeyValues keyValues;
    private KeyTimes keyTimes;
    private KeyInterpolators interpolators;

    public KeyFrames(KeyValues keyValues) {
        this.init(keyValues, null, new Interpolator[]{null});
    }

    public KeyFrames(KeyValues keyValues, KeyTimes keyTimes) {
        this.init(keyValues, keyTimes, new Interpolator[]{null});
    }

    public KeyFrames(KeyValues keyValues, KeyTimes keyTimes, Interpolator ... interpolators) {
        this.init(keyValues, keyTimes, interpolators);
    }

    public KeyFrames(KeyValues keyValues, Interpolator ... interpolators) {
        this.init(keyValues, null, interpolators);
    }

    private void init(KeyValues keyValues, KeyTimes keyTimes, Interpolator ... interpolators) {
        int numFrames = keyValues.getSize();
        if (keyTimes == null) {
            float timeVal;
            float[] keyTimesArray = new float[numFrames];
            keyTimesArray[0] = timeVal = 0.0f;
            for (int i10 = 1; i10 < numFrames - 1; ++i10) {
                keyTimesArray[i10] = timeVal += 1.0f / (float)(numFrames - 1);
            }
            keyTimesArray[numFrames - 1] = 1.0f;
            this.keyTimes = new KeyTimes(keyTimesArray);
        } else {
            this.keyTimes = keyTimes;
        }
        this.keyValues = keyValues;
        if (numFrames != this.keyTimes.getSize()) {
            throw new IllegalArgumentException("keyValues and keyTimes must be of equal size");
        }
        if (interpolators != null && interpolators.length != numFrames - 1 && interpolators.length != 1) {
            throw new IllegalArgumentException("interpolators must be either null (implying interpolation for all intervals), a single interpolator (which will be used for all intervals), or a number of interpolators equal to one less than the number of times.");
        }
        this.interpolators = new KeyInterpolators(numFrames - 1, interpolators);
    }

    Class getType() {
        return this.keyValues.getType();
    }

    KeyValues getKeyValues() {
        return this.keyValues;
    }

    KeyTimes getKeyTimes() {
        return this.keyTimes;
    }

    public int getInterval(float fraction) {
        return this.keyTimes.getInterval(fraction);
    }

    Object getValue(float fraction) {
        float t12;
        float t02;
        float t10;
        int interval = this.getInterval(fraction);
        float interpolatedT = this.interpolators.interpolate(interval, t10 = (fraction - (t02 = this.keyTimes.getTime(interval))) / ((t12 = this.keyTimes.getTime(interval + 1)) - t02));
        if (interpolatedT < 0.0f) {
            interpolatedT = 0.0f;
        } else if (interpolatedT > 1.0f) {
            interpolatedT = 1.0f;
        }
        return this.keyValues.getValue(interval, interval + 1, interpolatedT);
    }
}

