/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jdesktop.animation.timing.interpolation.Interpolator;
import org.jdesktop.animation.timing.interpolation.LengthItem;

public final class SplineInterpolator
implements Interpolator {
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private ArrayList lengths = new ArrayList();

    public SplineInterpolator(float x12, float y12, float x22, float y22) {
        if (x12 < 0.0f || x12 > 1.0f || y12 < 0.0f || y12 > 1.0f || x22 < 0.0f || x22 > 1.0f || y22 < 0.0f || y22 > 1.0f) {
            throw new IllegalArgumentException("Control points must be in the range [0, 1]:");
        }
        this.x1 = x12;
        this.y1 = y12;
        this.x2 = x22;
        this.y2 = y22;
        float prevX = 0.0f;
        float prevY = 0.0f;
        float prevLength = 0.0f;
        for (float t10 = 0.01f; t10 <= 1.0f; t10 += 0.01f) {
            Point2D.Float xy2 = this.getXY(t10);
            float length = prevLength + (float)Math.sqrt((xy2.x - prevX) * (xy2.x - prevX) + (xy2.y - prevY) * (xy2.y - prevY));
            LengthItem lengthItem = new LengthItem(length, t10);
            this.lengths.add(lengthItem);
            prevLength = length;
            prevX = xy2.x;
            prevY = xy2.y;
        }
        for (int i10 = 0; i10 < this.lengths.size(); ++i10) {
            LengthItem lengthItem = (LengthItem)this.lengths.get(i10);
            lengthItem.setFraction(prevLength);
        }
    }

    private Point2D.Float getXY(float t10) {
        float invT = 1.0f - t10;
        float b12 = 3.0f * t10 * (invT * invT);
        float b22 = 3.0f * (t10 * t10) * invT;
        float b32 = t10 * t10 * t10;
        Point2D.Float xy2 = new Point2D.Float(b12 * this.x1 + b22 * this.x2 + b32, b12 * this.y1 + b22 * this.y2 + b32);
        return xy2;
    }

    private float getY(float t10) {
        float invT = 1.0f - t10;
        float b12 = 3.0f * t10 * (invT * invT);
        float b22 = 3.0f * (t10 * t10) * invT;
        float b32 = t10 * t10 * t10;
        return b12 * this.y1 + b22 * this.y2 + b32;
    }

    public float interpolate(float lengthFraction) {
        float interpolatedT = 1.0f;
        float prevT = 0.0f;
        float prevLength = 0.0f;
        for (int i10 = 0; i10 < this.lengths.size(); ++i10) {
            LengthItem lengthItem = (LengthItem)this.lengths.get(i10);
            float fraction = lengthItem.getFraction();
            float t10 = lengthItem.getT();
            if (lengthFraction <= fraction) {
                float proportion = (lengthFraction - prevLength) / (fraction - prevLength);
                interpolatedT = prevT + proportion * (t10 - prevT);
                return this.getY(interpolatedT);
            }
            prevLength = fraction;
            prevT = t10;
        }
        return this.getY(interpolatedT);
    }
}

