/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.core;

import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.core.Inets;
import org.pcap4j.core.NativeMappings;
import org.pcap4j.core.PcapAddress;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapIpV4Address;
import org.pcap4j.core.PcapIpV6Address;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.util.ByteArrays;
import org.pcap4j.util.LinkLayerAddress;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PcapNetworkInterface {
    private static final Logger logger = LoggerFactory.getLogger(PcapNetworkInterface.class);
    private static final int PCAP_IF_LOOPBACK = 1;
    private final String name;
    private final String description;
    private final List<PcapAddress> addresses = new ArrayList<PcapAddress>();
    private final List<LinkLayerAddress> linkLayerAddresses = new ArrayList<LinkLayerAddress>();
    private final boolean loopBack;
    private final boolean local;

    private PcapNetworkInterface(NativeMappings.pcap_if pif, boolean local) {
        this.name = pif.name;
        this.description = pif.description;
        NativeMappings.pcap_addr.ByReference pcapAddr = pif.addresses;
        while (pcapAddr != null) {
            if (pcapAddr.addr == null && pcapAddr.netmask == null && pcapAddr.broadaddr == null && pcapAddr.dstaddr == null) {
                logger.warn("Empty pcap_addr on {} ({}). Ignore it.", (Object)this.name, (Object)this.description);
            } else {
                byte[] addr;
                short sa_family;
                short s10 = pcapAddr.addr != null ? pcapAddr.addr.getSaFamily() : (pcapAddr.netmask != null ? pcapAddr.netmask.getSaFamily() : (pcapAddr.broadaddr != null ? pcapAddr.broadaddr.getSaFamily() : (sa_family = pcapAddr.dstaddr != null ? pcapAddr.dstaddr.getSaFamily() : (short)0)));
                if (sa_family == Inets.AF_INET) {
                    this.addresses.add(PcapIpV4Address.newInstance(pcapAddr, sa_family, this.name));
                } else if (sa_family == Inets.AF_INET6) {
                    this.addresses.add(PcapIpV6Address.newInstance(pcapAddr, sa_family, this.name));
                } else if (Platform.isLinux() && sa_family == Inets.AF_PACKET) {
                    NativeMappings.sockaddr_ll sll = new NativeMappings.sockaddr_ll(pcapAddr.addr.getPointer());
                    addr = sll.sll_addr;
                    int addrLength = sll.sll_halen & 0xFF;
                    if (addrLength == 6) {
                        this.linkLayerAddresses.add(ByteArrays.getMacAddress(addr, 0));
                    } else if (addr.length != 0) {
                        this.linkLayerAddresses.add(LinkLayerAddress.getByAddress(ByteArrays.getSubArray(addr, 0, addrLength)));
                    }
                } else if (Platform.isMac() || Platform.isFreeBSD() || Platform.isOpenBSD() || Platform.iskFreeBSD() && sa_family == Inets.AF_LINK) {
                    NativeMappings.sockaddr_dl sdl = new NativeMappings.sockaddr_dl(pcapAddr.addr.getPointer());
                    addr = sdl.getAddress();
                    if (addr.length == 6) {
                        this.linkLayerAddresses.add(MacAddress.getByAddress(addr));
                    } else if (addr.length != 0) {
                        this.linkLayerAddresses.add(LinkLayerAddress.getByAddress(addr));
                    }
                } else {
                    logger.warn("{} is not supported address family. Ignore it.", (Object)sa_family);
                }
            }
            pcapAddr = pcapAddr.next;
        }
        this.loopBack = pif.flags == 1;
        this.local = local;
    }

    static PcapNetworkInterface newInstance(NativeMappings.pcap_if pif, boolean local) {
        return new PcapNetworkInterface(pif, local);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PcapAddress> getAddresses() {
        return new ArrayList<PcapAddress>(this.addresses);
    }

    public ArrayList<LinkLayerAddress> getLinkLayerAddresses() {
        return new ArrayList<LinkLayerAddress>(this.linkLayerAddresses);
    }

    public boolean isLoopBack() {
        return this.loopBack;
    }

    public boolean isLocal() {
        return this.local;
    }

    public PcapHandle openLive(int snaplen, PromiscuousMode mode, int timeoutMillis) throws PcapNativeException {
        if (mode == null) {
            StringBuilder sb2 = new StringBuilder();
            sb2.append("mode: ").append((Object)mode);
            throw new NullPointerException(sb2.toString());
        }
        NativeMappings.PcapErrbuf errbuf = new NativeMappings.PcapErrbuf();
        Pointer handle = NativeMappings.pcap_open_live(this.name, snaplen, mode.getValue(), timeoutMillis, errbuf);
        if (handle == null || errbuf.length() != 0) {
            throw new PcapNativeException(errbuf.toString());
        }
        if (timeoutMillis == 0 && Platform.isSolaris()) {
            NativeMappings.timeval to2 = new NativeMappings.timeval();
            to2.tv_sec = new NativeLong(0L);
            to2.tv_usec = new NativeLong(0L);
            int rc2 = NativeMappings.PcapLibrary.INSTANCE.strioctl(NativeMappings.getFdFromPcapT(handle), 16897, to2.size(), to2.getPointer());
            if (rc2 < 0) {
                throw new PcapNativeException("SBIOCSTIME: " + NativeMappings.pcap_strerror(NativeMappings.ERRNO_P.getInt(0L)).getString(0L));
            }
        }
        return new PcapHandle(handle, PcapHandle.TimestampPrecision.MICRO);
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder(250);
        sb2.append("name: [").append(this.name).append("] description: [").append(this.description);
        for (PcapAddress addr : this.addresses) {
            sb2.append("] address: [").append(addr.getAddress());
        }
        sb2.append("] loopBack: [").append(this.loopBack).append("]");
        sb2.append("] local: [").append(this.local).append("]");
        return sb2.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PcapNetworkInterface)) {
            return false;
        }
        PcapNetworkInterface other = (PcapNetworkInterface)obj;
        return this.name.equals(other.getName()) && this.local == other.isLocal();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static enum PromiscuousMode {
        PROMISCUOUS(1),
        NONPROMISCUOUS(0);

        private final int value;

        private PromiscuousMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

