/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.core;

import com.sun.jna.Pointer;
import org.pcap4j.core.NativeMappings;

public final class PcapStat {
    private final long numPacketsReceived;
    private final long numPacketsDropped;
    private final long numPacketsDroppedByIf;
    private final long numPacketsCaptured;

    PcapStat(NativeMappings.pcap_stat stat) {
        if (stat instanceof NativeMappings.win_pcap_stat) {
            NativeMappings.win_pcap_stat win_stat = (NativeMappings.win_pcap_stat)stat;
            this.numPacketsReceived = (long)win_stat.ps_recv & 0xFFFFFFFFL;
            this.numPacketsDropped = (long)win_stat.ps_drop & 0xFFFFFFFFL;
            this.numPacketsDroppedByIf = (long)win_stat.ps_ifdrop & 0xFFFFFFFFL;
            this.numPacketsCaptured = (long)win_stat.bs_capt & 0xFFFFFFFFL;
        } else {
            this.numPacketsReceived = (long)stat.ps_recv & 0xFFFFFFFFL;
            this.numPacketsDropped = (long)stat.ps_drop & 0xFFFFFFFFL;
            this.numPacketsDroppedByIf = (long)stat.ps_ifdrop & 0xFFFFFFFFL;
            this.numPacketsCaptured = 0L;
        }
    }

    PcapStat(Pointer p10, boolean isWinPcapStat) {
        this.numPacketsReceived = (long)NativeMappings.pcap_stat.getPsRecv(p10) & 0xFFFFFFFFL;
        this.numPacketsDropped = (long)NativeMappings.pcap_stat.getPsDrop(p10) & 0xFFFFFFFFL;
        this.numPacketsDroppedByIf = (long)NativeMappings.pcap_stat.getPsIfdrop(p10) & 0xFFFFFFFFL;
        this.numPacketsCaptured = isWinPcapStat ? (long)NativeMappings.win_pcap_stat.getBsCapt(p10) & 0xFFFFFFFFL : 0L;
    }

    public long getNumPacketsReceived() {
        return this.numPacketsReceived;
    }

    public long getNumPacketsDropped() {
        return this.numPacketsDropped;
    }

    public long getNumPacketsDroppedByIf() {
        return this.numPacketsDroppedByIf;
    }

    public long getNumPacketsCaptured() {
        return this.numPacketsCaptured;
    }
}

