/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.ProtocolFamily;
import org.pcap4j.util.ByteArrays;

public final class BsdLoopbackPacket
extends AbstractPacket {
    private static final long serialVersionUID = 5348192606048946251L;
    private final BsdLoopbackHeader header;
    private final Packet payload;

    public static BsdLoopbackPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new BsdLoopbackPacket(rawData, offset, length);
    }

    private BsdLoopbackPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new BsdLoopbackHeader(rawData, offset, length);
        int payloadLength = length - this.header.length();
        this.payload = payloadLength > 0 ? PacketFactories.getFactory(Packet.class, ProtocolFamily.class).newInstance(rawData, offset + this.header.length(), payloadLength, this.header.getProtocolFamily()) : null;
    }

    private BsdLoopbackPacket(Builder builder) {
        if (builder == null || builder.protocolFamily == null) {
            StringBuilder sb2 = new StringBuilder();
            sb2.append("builder: ").append(builder).append(" builder.packetType: ").append(builder.protocolFamily);
            throw new NullPointerException(sb2.toString());
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new BsdLoopbackHeader(builder);
    }

    @Override
    public BsdLoopbackHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class BsdLoopbackHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -1053845855337317937L;
        private static final int PROTOCOL_FAMILY_OFFSET = 0;
        private static final int PROTOCOL_FAMILY_SIZE = 4;
        private static final int BSD_LOOPBACK_HEADER_SIZE = 4;
        private final ProtocolFamily protocolFamily;

        private BsdLoopbackHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 4) {
                StringBuilder sb2 = new StringBuilder(200);
                sb2.append("The data is too short to build a BSD loopback header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb2.toString());
            }
            this.protocolFamily = ProtocolFamily.getInstance(ByteArrays.getInt(rawData, 0 + offset, ByteOrder.nativeOrder()));
        }

        private BsdLoopbackHeader(Builder builder) {
            this.protocolFamily = builder.protocolFamily;
        }

        public ProtocolFamily getProtocolFamily() {
            return this.protocolFamily;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((int)((Integer)this.protocolFamily.value()), ByteOrder.nativeOrder()));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb2 = new StringBuilder();
            String ls2 = System.getProperty("line.separator");
            sb2.append("[BSD Loopback Header (").append(this.length()).append(" bytes)]").append(ls2);
            sb2.append("  Protocol Family: ").append(this.protocolFamily).append(ls2);
            return sb2.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            BsdLoopbackHeader other = (BsdLoopbackHeader)obj;
            return this.protocolFamily.equals(other.protocolFamily);
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.protocolFamily.hashCode();
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private ProtocolFamily protocolFamily;
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        private Builder(BsdLoopbackPacket packet) {
            this.protocolFamily = packet.header.protocolFamily;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder protocolFamily(ProtocolFamily protocolFamily) {
            this.protocolFamily = protocolFamily;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        @Override
        public BsdLoopbackPacket build() {
            return new BsdLoopbackPacket(this);
        }
    }
}

