/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPppPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.namednumber.PppDllProtocol;
import org.pcap4j.util.ByteArrays;

public class HdlcPppPacket
extends AbstractPppPacket {
    private static final long serialVersionUID = -5976235177385846196L;
    private final HdlcPppHeader header;

    public static HdlcPppPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        HdlcPppHeader header = new HdlcPppHeader(rawData, offset, length);
        return new HdlcPppPacket(rawData, offset, length, header);
    }

    private HdlcPppPacket(byte[] rawData, int offset, int length, HdlcPppHeader header) throws IllegalRawDataException {
        super(rawData, offset, length, header);
        this.header = header;
    }

    private HdlcPppPacket(Builder builder) {
        super(builder);
        this.header = new HdlcPppHeader(builder);
    }

    @Override
    public HdlcPppHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends AbstractPppPacket.Builder {
        private byte address = (byte)-1;
        private byte control = (byte)3;

        public Builder() {
        }

        private Builder(HdlcPppPacket packet) {
            super(packet);
            this.address = packet.header.address;
            this.control = packet.header.control;
        }

        public Builder address(byte address) {
            this.address = address;
            return this;
        }

        public Builder control(byte control) {
            this.control = control;
            return this;
        }

        @Override
        public Builder protocol(PppDllProtocol protocol) {
            super.protocol(protocol);
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            super.payloadBuilder(payloadBuilder);
            return this;
        }

        @Override
        public Builder pad(byte[] pad) {
            super.pad(pad);
            return this;
        }

        @Override
        public HdlcPppPacket build() {
            return new HdlcPppPacket(this);
        }
    }

    public static class HdlcPppHeader
    extends AbstractPppPacket.AbstractPppHeader {
        private static final long serialVersionUID = -6084002362363168427L;
        private static final int ADDRESS_OFFSET = 0;
        private static final int ADDRESS_SIZE = 1;
        private static final int CONTROL_OFFSET = 1;
        private static final int CONTROL_SIZE = 1;
        private static final int PPP_HEADER_OFFSET = 2;
        private static final int HDLC_PPP_HEADER_SIZE = 4;
        private final byte address;
        private final byte control;

        private HdlcPppHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            super(rawData, offset + 2, length - 2);
            if (length < 4) {
                StringBuilder sb2 = new StringBuilder(100);
                sb2.append("The data is too short to build an HDLC PPP header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb2.toString());
            }
            this.address = ByteArrays.getByte(rawData, 0 + offset);
            this.control = ByteArrays.getByte(rawData, 1 + offset);
        }

        private HdlcPppHeader(Builder builder) {
            super(builder);
            this.address = builder.address;
            this.control = builder.control;
        }

        public byte getAddress() {
            return this.address;
        }

        public byte getControl() {
            return this.control;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.address));
            rawFields.add(ByteArrays.toByteArray(this.control));
            rawFields.add(ByteArrays.toByteArray((Short)this.getProtocol().value()));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb2 = new StringBuilder();
            String ls2 = System.getProperty("line.separator");
            sb2.append("[HDLC-encapsulated PPP Header (").append(this.length()).append(" bytes)]").append(ls2);
            sb2.append("  Address: 0x").append(String.format("%02x", this.address)).append(ls2);
            sb2.append("  Control: 0x").append(String.format("%02x", this.control)).append(ls2);
            sb2.append("  Protocol: ").append(this.getProtocol()).append(ls2);
            return sb2.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            HdlcPppHeader other = (HdlcPppHeader)obj;
            return this.address == other.address && this.control == other.control;
        }

        @Override
        protected int calcHashCode() {
            int result = super.calcHashCode();
            result = 31 * result + this.address;
            result = 31 * result + this.control;
            return result;
        }
    }
}

