/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IcmpV4InvokingPacketPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.util.ByteArrays;

public final class IcmpV4ParameterProblemPacket
extends IcmpV4InvokingPacketPacket {
    private static final long serialVersionUID = 5369176981310492220L;
    private final IcmpV4ParameterProblemHeader header;

    public static IcmpV4ParameterProblemPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        IcmpV4ParameterProblemHeader header = new IcmpV4ParameterProblemHeader(rawData, offset, length);
        int payloadLength = length - header.length();
        if (payloadLength > 0) {
            return new IcmpV4ParameterProblemPacket(header, rawData, offset + header.length(), payloadLength);
        }
        return new IcmpV4ParameterProblemPacket(header);
    }

    private IcmpV4ParameterProblemPacket(IcmpV4ParameterProblemHeader header) {
        this.header = header;
    }

    private IcmpV4ParameterProblemPacket(IcmpV4ParameterProblemHeader header, byte[] rawData, int payloadOffset, int payloadLength) {
        super(rawData, payloadOffset, payloadLength);
        this.header = header;
    }

    private IcmpV4ParameterProblemPacket(Builder builder) {
        super(builder);
        this.header = new IcmpV4ParameterProblemHeader(builder);
    }

    @Override
    public IcmpV4ParameterProblemHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class Builder
    extends IcmpV4InvokingPacketPacket.Builder {
        private byte pointer;
        private int unused;

        public Builder() {
        }

        private Builder(IcmpV4ParameterProblemPacket packet) {
            super(packet);
            this.pointer = packet.header.pointer;
            this.unused = packet.header.unused;
        }

        public Builder pointer(byte pointer) {
            this.pointer = pointer;
            return this;
        }

        public Builder unused(int unused) {
            this.unused = unused;
            return this;
        }

        @Override
        public Builder payload(Packet payload) {
            super.payload(payload);
            return this;
        }

        @Override
        public IcmpV4ParameterProblemPacket build() {
            return new IcmpV4ParameterProblemPacket(this);
        }
    }

    public static final class IcmpV4ParameterProblemHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 7946304491624744071L;
        private static final int POINTER_AND_UNUSED_OFFSET = 0;
        private static final int POINTER_AND_UNUSED_SIZE = 4;
        private static final int ICMPV4_PARAMETER_PROBLEM_HEADER_SIZE = 4;
        private final byte pointer;
        private final int unused;

        private IcmpV4ParameterProblemHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 4) {
                StringBuilder sb2 = new StringBuilder(80);
                sb2.append("The data is too short to build an ICMPv4 Parameter Problem Header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb2.toString());
            }
            int pointerAndUnused = ByteArrays.getInt(rawData, 0 + offset);
            this.pointer = (byte)(pointerAndUnused >>> 24);
            this.unused = pointerAndUnused & 0xFFFFFF;
        }

        private IcmpV4ParameterProblemHeader(Builder builder) {
            if ((builder.unused & 0xFF000000) != 0) {
                throw new IllegalArgumentException("Invalid unused: " + builder.unused);
            }
            this.pointer = builder.pointer;
            this.unused = builder.unused;
        }

        public byte getPointer() {
            return this.pointer;
        }

        public int getPointerAsInt() {
            return this.pointer & 0xFF;
        }

        public int getUnused() {
            return this.unused;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.pointer << 24 | this.unused));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb2 = new StringBuilder();
            String ls2 = System.getProperty("line.separator");
            sb2.append("[ICMPv4 Parameter Problem Header (").append(this.length()).append(" bytes)]").append(ls2);
            sb2.append("  Pointer: ").append(this.getPointerAsInt()).append(ls2);
            sb2.append("  Unused: ").append(this.unused).append(ls2);
            return sb2.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IcmpV4ParameterProblemHeader other = (IcmpV4ParameterProblemHeader)obj;
            return this.pointer == other.pointer && this.unused == other.unused;
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.pointer;
            result = 31 * result + this.unused;
            return result;
        }
    }
}

