/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.ChecksumBuilder;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.NotApplicable;

abstract class IcmpV6InvokingPacketPacket
extends AbstractPacket {
    private static final long serialVersionUID = 1169814867596950985L;
    private final Packet payload;

    protected IcmpV6InvokingPacketPacket() {
        this.payload = null;
    }

    protected IcmpV6InvokingPacketPacket(byte[] rawData, int payloadOffset, int payloadLength) {
        Packet p10 = PacketFactories.getFactory(Packet.class, EtherType.class).newInstance(rawData, payloadOffset, payloadLength, EtherType.IPV6);
        if (p10 instanceof IllegalPacket) {
            this.payload = p10;
            return;
        }
        if (p10.contains(IllegalPacket.class)) {
            Packet.Builder builder = p10.getBuilder();
            byte[] ipRawData = p10.get(IllegalPacket.class).getRawData();
            builder.getOuterOf(IllegalPacket.Builder.class).payloadBuilder(PacketFactories.getFactory(Packet.class, NotApplicable.class).newInstance(ipRawData, 0, ipRawData.length, NotApplicable.UNKNOWN).getBuilder());
            for (Packet.Builder b10 : builder) {
                if (b10 instanceof LengthBuilder) {
                    ((LengthBuilder)((Object)b10)).correctLengthAtBuild(false);
                }
                if (!(b10 instanceof ChecksumBuilder)) continue;
                ((ChecksumBuilder)((Object)b10)).correctChecksumAtBuild(false);
            }
            p10 = builder.build();
        }
        this.payload = p10;
    }

    protected IcmpV6InvokingPacketPacket(Builder builder) {
        if (builder == null) {
            StringBuilder sb2 = new StringBuilder();
            sb2.append("builder: ").append(builder);
            throw new NullPointerException(sb2.toString());
        }
        this.payload = builder.payload;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    static abstract class Builder
    extends AbstractPacket.AbstractBuilder {
        private Packet payload;

        public Builder() {
        }

        protected Builder(IcmpV6InvokingPacketPacket packet) {
            this.payload = packet.payload;
        }

        public Builder payload(Packet payload) {
            this.payload = payload;
            return this;
        }
    }
}

