/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IcmpV6InvokingPacketPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.util.ByteArrays;

public final class IcmpV6PacketTooBigPacket
extends IcmpV6InvokingPacketPacket {
    private static final long serialVersionUID = -8558258364388627250L;
    private final IcmpV6PacketTooBigHeader header;

    public static IcmpV6PacketTooBigPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        IcmpV6PacketTooBigHeader header = new IcmpV6PacketTooBigHeader(rawData, offset, length);
        int payloadLength = length - header.length();
        if (payloadLength > 0) {
            return new IcmpV6PacketTooBigPacket(header, rawData, offset + header.length(), payloadLength);
        }
        return new IcmpV6PacketTooBigPacket(header);
    }

    private IcmpV6PacketTooBigPacket(IcmpV6PacketTooBigHeader header) {
        this.header = header;
    }

    private IcmpV6PacketTooBigPacket(IcmpV6PacketTooBigHeader header, byte[] rawData, int payloadOffset, int payloadLength) {
        super(rawData, payloadOffset, payloadLength);
        this.header = header;
    }

    private IcmpV6PacketTooBigPacket(Builder builder) {
        super(builder);
        this.header = new IcmpV6PacketTooBigHeader(builder);
    }

    @Override
    public IcmpV6PacketTooBigHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class Builder
    extends IcmpV6InvokingPacketPacket.Builder {
        private int mtu;

        public Builder() {
        }

        private Builder(IcmpV6PacketTooBigPacket packet) {
            super(packet);
            this.mtu = packet.getHeader().mtu;
        }

        public Builder mtu(int mtu) {
            this.mtu = mtu;
            return this;
        }

        @Override
        public Builder payload(Packet payload) {
            super.payload(payload);
            return this;
        }

        @Override
        public IcmpV6PacketTooBigPacket build() {
            return new IcmpV6PacketTooBigPacket(this);
        }
    }

    public static final class IcmpV6PacketTooBigHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 8034982803428261280L;
        private static final int MTU_OFFSET = 0;
        private static final int MTU_SIZE = 4;
        private static final int ICMPV6_PACKET_TOO_BIG_HEADER_SIZE = 4;
        private final int mtu;

        private IcmpV6PacketTooBigHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 4) {
                StringBuilder sb2 = new StringBuilder(80);
                sb2.append("The data is too short to build an ICMPv6 Packet Too Big Header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb2.toString());
            }
            this.mtu = ByteArrays.getInt(rawData, 0 + offset);
        }

        private IcmpV6PacketTooBigHeader(Builder builder) {
            this.mtu = builder.mtu;
        }

        public int getMtu() {
            return this.mtu;
        }

        public long getMtuAsLong() {
            return (long)this.mtu & 0xFFFFFFFFL;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.mtu));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb2 = new StringBuilder();
            String ls2 = System.getProperty("line.separator");
            sb2.append("[ICMPv6 Packet Too Big Header (").append(this.length()).append(" bytes)]").append(ls2);
            sb2.append("  MTU: ").append(this.mtu).append(ls2);
            return sb2.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IcmpV6PacketTooBigHeader other = (IcmpV6PacketTooBigHeader)obj;
            return this.mtu == other.mtu;
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.mtu;
            return result;
        }
    }
}

