/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IcmpV6InvokingPacketPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.util.ByteArrays;

public final class IcmpV6TimeExceededPacket
extends IcmpV6InvokingPacketPacket {
    private static final long serialVersionUID = 548806622487019458L;
    private final IcmpV6TimeExceededHeader header;

    public static IcmpV6TimeExceededPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        IcmpV6TimeExceededHeader header = new IcmpV6TimeExceededHeader(rawData, offset, length);
        int payloadLength = length - header.length();
        if (payloadLength > 0) {
            return new IcmpV6TimeExceededPacket(header, rawData, offset + header.length(), payloadLength);
        }
        return new IcmpV6TimeExceededPacket(header);
    }

    private IcmpV6TimeExceededPacket(IcmpV6TimeExceededHeader header) {
        this.header = header;
    }

    private IcmpV6TimeExceededPacket(IcmpV6TimeExceededHeader header, byte[] rawData, int payloadOffset, int payloadLength) {
        super(rawData, payloadOffset, payloadLength);
        this.header = header;
    }

    private IcmpV6TimeExceededPacket(Builder builder) {
        super(builder);
        this.header = new IcmpV6TimeExceededHeader(builder);
    }

    @Override
    public IcmpV6TimeExceededHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class Builder
    extends IcmpV6InvokingPacketPacket.Builder {
        private int unused;

        public Builder() {
        }

        private Builder(IcmpV6TimeExceededPacket packet) {
            super(packet);
            this.unused = packet.getHeader().unused;
        }

        public Builder unused(int unused) {
            this.unused = unused;
            return this;
        }

        @Override
        public Builder payload(Packet payload) {
            super.payload(payload);
            return this;
        }

        @Override
        public IcmpV6TimeExceededPacket build() {
            return new IcmpV6TimeExceededPacket(this);
        }
    }

    public static final class IcmpV6TimeExceededHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 7744561095455514341L;
        private static final int UNUSED_OFFSET = 0;
        private static final int UNUSED_SIZE = 4;
        private static final int ICMPV6_TIME_EXCEEDED_HEADER_SIZE = 4;
        private final int unused;

        private IcmpV6TimeExceededHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 4) {
                StringBuilder sb2 = new StringBuilder(80);
                sb2.append("The data is too short to build an ICMPv6 Time Exceeded Header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb2.toString());
            }
            this.unused = ByteArrays.getInt(rawData, 0 + offset);
        }

        private IcmpV6TimeExceededHeader(Builder builder) {
            this.unused = builder.unused;
        }

        public int getUnused() {
            return this.unused;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.unused));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb2 = new StringBuilder();
            String ls2 = System.getProperty("line.separator");
            sb2.append("[ICMPv6 Time Exceeded Header (").append(this.length()).append(" bytes)]").append(ls2);
            sb2.append("  Unused: ").append(this.unused).append(ls2);
            return sb2.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IcmpV6TimeExceededHeader other = (IcmpV6TimeExceededHeader)obj;
            return this.unused == other.unused;
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.unused;
            return result;
        }
    }
}

