/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.util.ByteArrays;

public final class IllegalPacket
extends AbstractPacket {
    private static final long serialVersionUID = -8028013257441150031L;
    private final byte[] rawData;

    public static IllegalPacket newPacket(byte[] rawData, int offset, int length) {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IllegalPacket(rawData, offset, length);
    }

    private IllegalPacket(byte[] rawData, int offset, int length) {
        this.rawData = new byte[length];
        System.arraycopy(rawData, offset, this.rawData, 0, length);
    }

    private IllegalPacket(Builder builder) {
        if (builder == null || builder.rawData == null) {
            throw new NullPointerException();
        }
        this.rawData = new byte[builder.rawData.length];
        System.arraycopy(builder.rawData, 0, this.rawData, 0, builder.rawData.length);
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] copy = new byte[this.rawData.length];
        System.arraycopy(this.rawData, 0, copy, 0, copy.length);
        return copy;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    protected String buildString() {
        StringBuilder sb2 = new StringBuilder();
        String ls2 = System.getProperty("line.separator");
        sb2.append("[Illegal Packet (").append(this.length()).append(" bytes)]").append(ls2);
        sb2.append("  Hex stream: ").append(ByteArrays.toHexString(this.rawData, " ")).append(ls2);
        return sb2.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IllegalPacket other = (IllegalPacket)obj;
        return Arrays.equals(this.rawData, other.rawData);
    }

    @Override
    protected int calcHashCode() {
        return Arrays.hashCode(this.rawData);
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private byte[] rawData = new byte[0];

        public Builder() {
        }

        private Builder(IllegalPacket packet) {
            this.rawData = packet.rawData;
        }

        public Builder rawData(byte[] rawData) {
            this.rawData = rawData;
            return this;
        }

        @Override
        public IllegalPacket build() {
            return new IllegalPacket(this);
        }
    }
}

