/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4InternetTimestampOption;
import org.pcap4j.util.ByteArrays;

public final class IpV4InternetTimestampOptionAddressPrespecified
implements IpV4InternetTimestampOption.IpV4InternetTimestampOptionData {
    private static final long serialVersionUID = 3865517048348635723L;
    private final Inet4Address address;
    private final List<Integer> timestamps;

    public static IpV4InternetTimestampOptionAddressPrespecified newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IpV4InternetTimestampOptionAddressPrespecified(rawData, offset, length);
    }

    private IpV4InternetTimestampOptionAddressPrespecified(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length % 4 != 0) {
            StringBuilder sb2 = new StringBuilder(100);
            sb2.append("The raw data length must be an integer multiple of 4 octets long. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb2.toString());
        }
        this.address = ByteArrays.getInet4Address(rawData, 0 + offset);
        this.timestamps = new ArrayList<Integer>();
        for (int i10 = 4; i10 < length; i10 += 4) {
            this.timestamps.add(ByteArrays.getInt(rawData, i10 + offset));
        }
    }

    public IpV4InternetTimestampOptionAddressPrespecified(Inet4Address address, List<Integer> timestamps) {
        if (timestamps == null) {
            throw new NullPointerException("timestamps may not be null");
        }
        if (address == null && timestamps.size() != 0) {
            throw new IllegalArgumentException("timestamps.size() must be 0 if address is null");
        }
        this.address = address;
        this.timestamps = new ArrayList<Integer>(timestamps);
    }

    public Inet4Address getAddress() {
        return this.address;
    }

    public List<Integer> getTimestamps() {
        return new ArrayList<Integer>(this.timestamps);
    }

    @Override
    public int length() {
        if (this.address == null) {
            return 0;
        }
        return 4 + this.timestamps.size() * 4;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        Iterator<Integer> iter = this.timestamps.iterator();
        for (int i10 = 0; i10 < rawData.length; i10 += 4) {
            System.arraycopy(ByteArrays.toByteArray(iter.next()), 0, rawData, 0, 4);
        }
        return rawData;
    }

    public String toString() {
        if (this.address == null) {
            return "[]";
        }
        StringBuilder sb2 = new StringBuilder();
        sb2.append("[address: ").append(this.address);
        sb2.append("] [timestamps:");
        for (Integer ts2 : this.timestamps) {
            sb2.append(" ").append((long)ts2.intValue() & 0xFFFFFFFFL);
        }
        sb2.append("]");
        return sb2.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return Arrays.equals(((IpV4InternetTimestampOptionAddressPrespecified)this.getClass().cast(obj)).getRawData(), this.getRawData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getRawData());
    }
}

