/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4InternetTimestampOption;
import org.pcap4j.util.ByteArrays;

public final class IpV4InternetTimestampOptionTimestamps
implements IpV4InternetTimestampOption.IpV4InternetTimestampOptionData {
    private static final long serialVersionUID = -2067863811913941432L;
    private final List<Integer> timestamps;

    public static IpV4InternetTimestampOptionTimestamps newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IpV4InternetTimestampOptionTimestamps(rawData, offset, length);
    }

    private IpV4InternetTimestampOptionTimestamps(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length % 4 != 0) {
            StringBuilder sb2 = new StringBuilder(100);
            sb2.append("The raw data length must be an integer multiple of 4 octets long. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb2.toString());
        }
        this.timestamps = new ArrayList<Integer>();
        for (int i10 = 0; i10 < length; i10 += 4) {
            this.timestamps.add(ByteArrays.getInt(rawData, i10 + offset));
        }
    }

    public IpV4InternetTimestampOptionTimestamps(List<Integer> timestamps) {
        if (timestamps == null) {
            throw new NullPointerException("timestamps may not be null");
        }
        this.timestamps = new ArrayList<Integer>(timestamps);
    }

    public List<Integer> getTimestamps() {
        return new ArrayList<Integer>(this.timestamps);
    }

    @Override
    public int length() {
        return this.timestamps.size() * 4;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        Iterator<Integer> iter = this.timestamps.iterator();
        for (int i10 = 0; i10 < rawData.length; i10 += 4) {
            System.arraycopy(ByteArrays.toByteArray(iter.next()), 0, rawData, 0, 4);
        }
        return rawData;
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("[timestamps:");
        for (Integer ts2 : this.timestamps) {
            sb2.append(" ").append((long)ts2.intValue() & 0xFFFFFFFFL);
        }
        sb2.append("]");
        return sb2.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return Arrays.equals(((IpV4InternetTimestampOptionTimestamps)this.getClass().cast(obj)).getRawData(), this.getRawData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getRawData());
    }
}

