/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4InternetTimestampOption;
import org.pcap4j.util.ByteArrays;

public final class IpV4InternetTimestampOptionTimestampsWithAddresses
implements IpV4InternetTimestampOption.IpV4InternetTimestampOptionData {
    private static final long serialVersionUID = -331040457248187753L;
    private final List<TimestampWithAddress> timestampsWithAddresses;

    public static IpV4InternetTimestampOptionTimestampsWithAddresses newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IpV4InternetTimestampOptionTimestampsWithAddresses(rawData, offset, length);
    }

    private IpV4InternetTimestampOptionTimestampsWithAddresses(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length % 4 != 0) {
            StringBuilder sb2 = new StringBuilder(100);
            sb2.append("The raw data length must be an integer multiple of 4 octets long. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb2.toString());
        }
        this.timestampsWithAddresses = new ArrayList<TimestampWithAddress>();
        for (int i10 = 0; i10 < length; i10 += 8) {
            Inet4Address address = ByteArrays.getInet4Address(rawData, i10 + offset);
            Integer timestamp = null;
            if (i10 + 4 < length) {
                timestamp = ByteArrays.getInt(rawData, i10 + 4 + offset);
            }
            this.timestampsWithAddresses.add(new TimestampWithAddress(address, timestamp));
        }
    }

    public IpV4InternetTimestampOptionTimestampsWithAddresses(List<TimestampWithAddress> timestampsWithAddresses) {
        if (timestampsWithAddresses == null) {
            throw new NullPointerException("timestamps may not be null");
        }
        Iterator<TimestampWithAddress> iter = timestampsWithAddresses.iterator();
        while (iter.hasNext()) {
            TimestampWithAddress twa = iter.next();
            if (twa.timestamp != null || !iter.hasNext()) continue;
            throw new IllegalArgumentException("Every element of timestampsWithAddresses must not have null field except last element.");
        }
        this.timestampsWithAddresses = new ArrayList<TimestampWithAddress>(timestampsWithAddresses);
    }

    public List<TimestampWithAddress> getTimestampWithAddress() {
        return new ArrayList<TimestampWithAddress>(this.timestampsWithAddresses);
    }

    @Override
    public int length() {
        if (this.timestampsWithAddresses.get(this.timestampsWithAddresses.size() - 1).timestamp == null) {
            return this.timestampsWithAddresses.size() * 4 * 2 - 4;
        }
        return this.timestampsWithAddresses.size() * 4 * 2;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        Iterator<TimestampWithAddress> iter = this.timestampsWithAddresses.iterator();
        for (int i10 = 0; i10 < rawData.length; i10 += 8) {
            TimestampWithAddress twa = iter.next();
            System.arraycopy(ByteArrays.toByteArray(twa.address), 0, rawData, i10, 4);
            if (twa.timestamp == null) continue;
            System.arraycopy(ByteArrays.toByteArray(twa.timestamp), 0, rawData, i10 + 4, 4);
        }
        return rawData;
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("[(address, timestamp):");
        for (TimestampWithAddress twa : this.timestampsWithAddresses) {
            sb2.append(twa);
        }
        sb2.append("]");
        return sb2.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return Arrays.equals(((IpV4InternetTimestampOptionTimestampsWithAddresses)this.getClass().cast(obj)).getRawData(), this.getRawData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getRawData());
    }

    public static final class TimestampWithAddress
    implements Serializable {
        private static final long serialVersionUID = -1592713837380606740L;
        private final Inet4Address address;
        private final Integer timestamp;

        public TimestampWithAddress(Inet4Address address, Integer timestamp) {
            if (address == null) {
                throw new NullPointerException("address may not be null");
            }
            this.address = address;
            this.timestamp = timestamp;
        }

        public Inet4Address getAddress() {
            return this.address;
        }

        public Integer getTimestamp() {
            return this.timestamp;
        }

        public String toString() {
            StringBuilder sb2 = new StringBuilder();
            sb2.append("(").append(this.address).append(", ");
            if (this.timestamp != null) {
                sb2.append((long)this.timestamp.intValue() & 0xFFFFFFFFL);
            }
            sb2.append(")");
            return sb2.toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            TimestampWithAddress other = (TimestampWithAddress)obj;
            return this.timestamp.equals(other.timestamp) && this.address.equals(other.address);
        }

        public int hashCode() {
            int hash = 17;
            if (this.timestamp != null) {
                hash = 31 * hash + this.timestamp.hashCode();
            }
            hash = 31 * hash + this.address.hashCode();
            return hash;
        }
    }
}

