/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.namednumber.IpV4OptionType;
import org.pcap4j.util.ByteArrays;

abstract class IpV4RouteOption
implements IpV4Packet.IpV4Option {
    private static final long serialVersionUID = -2747065348720047861L;
    private final byte length;
    private final byte pointer;
    private final List<Inet4Address> routeData;

    protected IpV4RouteOption(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 3) {
            StringBuilder sb2 = new StringBuilder(100);
            sb2.append("The raw data length must be more than 2. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb2.toString());
        }
        if (rawData[0 + offset] != (Byte)this.getType().value()) {
            StringBuilder sb3 = new StringBuilder(100);
            sb3.append("The type must be: ").append(this.getType().valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb3.toString());
        }
        this.length = rawData[1 + offset];
        int lengthFieldAsInt = this.getLengthAsInt();
        if (length < lengthFieldAsInt) {
            StringBuilder sb4 = new StringBuilder(100);
            sb4.append("The raw data is too short to build this option(").append(lengthFieldAsInt).append("). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb4.toString());
        }
        if (lengthFieldAsInt < 3) {
            StringBuilder sb5 = new StringBuilder(100);
            sb5.append("The length field value must be equal or more than 3 but it is: ").append(lengthFieldAsInt);
            throw new IllegalRawDataException(sb5.toString());
        }
        if ((lengthFieldAsInt - 3) % 4 != 0) {
            throw new IllegalRawDataException("Invalid length for this option: " + lengthFieldAsInt);
        }
        this.pointer = rawData[2 + offset];
        this.routeData = new ArrayList<Inet4Address>();
        for (int i10 = 3; i10 < lengthFieldAsInt; i10 += 4) {
            this.routeData.add(ByteArrays.getInet4Address(rawData, i10 + offset));
        }
    }

    protected IpV4RouteOption(Builder<? extends IpV4RouteOption> builder) {
        if (builder == null || ((Builder)builder).routeData == null) {
            StringBuilder sb2 = new StringBuilder();
            sb2.append("builder: ").append(builder).append(" builder.routeData: ").append(((Builder)builder).routeData);
            throw new NullPointerException(sb2.toString());
        }
        this.pointer = ((Builder)builder).pointer;
        this.routeData = new ArrayList<Inet4Address>(((Builder)builder).routeData);
        this.length = ((Builder)builder).correctLengthAtBuild ? (byte)this.length() : ((Builder)builder).length;
    }

    @Override
    public abstract IpV4OptionType getType();

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public byte getPointer() {
        return this.pointer;
    }

    public int getPointerAsInt() {
        return 0xFF & this.pointer;
    }

    public List<Inet4Address> getRouteData() {
        return new ArrayList<Inet4Address>(this.routeData);
    }

    @Override
    public int length() {
        return this.routeData.size() * 4 + 3;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getType().value();
        rawData[1] = this.length;
        rawData[2] = this.pointer;
        int i10 = 3;
        for (Inet4Address addr : this.routeData) {
            System.arraycopy(addr.getAddress(), 0, rawData, i10, 4);
            i10 += 4;
        }
        return rawData;
    }

    public abstract Builder<? extends IpV4RouteOption> getBuilder();

    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("[option-type: ").append(this.getType());
        sb2.append("] [option-length: ").append(this.getLengthAsInt());
        sb2.append(" bytes] [pointer: ").append(this.getPointerAsInt());
        sb2.append("] [route data:");
        for (Inet4Address addr : this.routeData) {
            sb2.append(" ").append(addr);
        }
        sb2.append("]");
        return sb2.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IpV4RouteOption other = (IpV4RouteOption)obj;
        return this.length == other.length && this.pointer == other.pointer && this.routeData.equals(other.routeData);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.length;
        result = 31 * result + this.pointer;
        result = 31 * result + this.routeData.hashCode();
        return result;
    }

    static abstract class Builder<T extends IpV4RouteOption>
    implements LengthBuilder<T> {
        private byte length;
        private byte pointer;
        private List<Inet4Address> routeData;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        protected Builder(IpV4RouteOption option) {
            this.length = option.length;
            this.pointer = option.pointer;
            this.routeData = option.routeData;
        }

        public Builder<T> length(byte length) {
            this.length = length;
            return this;
        }

        public Builder<T> pointer(byte pointer) {
            this.pointer = pointer;
            return this;
        }

        public Builder<T> routeData(List<Inet4Address> routeData) {
            this.routeData = routeData;
            return this;
        }

        @Override
        public Builder<T> correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public abstract T build();
    }
}

