/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpV6OptionType;
import org.pcap4j.packet.namednumber.NotApplicable;
import org.pcap4j.util.ByteArrays;

public abstract class IpV6ExtOptionsPacket
extends AbstractPacket {
    private final Packet payload;
    private static final long serialVersionUID = 416178196599916582L;

    protected IpV6ExtOptionsPacket() {
        this.payload = null;
    }

    protected IpV6ExtOptionsPacket(byte[] rawData, int payloadOffset, int payloadLength, IpNumber number) {
        Packet nextPacket;
        PacketFactory<Packet, IpNumber> factory = PacketFactories.getFactory(Packet.class, IpNumber.class);
        Class<Packet> nextPacketClass = factory.getTargetClass(number);
        if (nextPacketClass.equals(factory.getTargetClass())) {
            nextPacket = PacketFactories.getFactory(Packet.class, NotApplicable.class).newInstance(rawData, payloadOffset, payloadLength, NotApplicable.UNKNOWN_IP_V6_EXTENSION);
            if (nextPacket instanceof IllegalPacket) {
                nextPacket = factory.newInstance(rawData, payloadOffset, payloadLength);
            }
        } else {
            nextPacket = factory.newInstance(rawData, payloadOffset, payloadLength, number);
        }
        this.payload = nextPacket;
    }

    protected IpV6ExtOptionsPacket(Builder builder) {
        if (builder == null || builder.nextHeader == null || builder.options == null) {
            StringBuilder sb2 = new StringBuilder();
            sb2.append("builder: ").append(builder).append(" builder.nextHeader: ").append(builder.nextHeader).append(" builder.options: ").append(builder.options);
            throw new NullPointerException(sb2.toString());
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
    }

    @Override
    public abstract IpV6ExtOptionsHeader getHeader();

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    public static abstract class Builder
    extends AbstractPacket.AbstractBuilder
    implements LengthBuilder<IpV6ExtOptionsPacket> {
        private IpNumber nextHeader;
        private byte hdrExtLen;
        private List<IpV6Option> options;
        private Packet.Builder payloadBuilder;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        protected Builder(IpV6ExtOptionsPacket packet) {
            this.nextHeader = packet.getHeader().nextHeader;
            this.hdrExtLen = packet.getHeader().hdrExtLen;
            this.options = packet.getHeader().options;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder nextHeader(IpNumber nextHeader) {
            this.nextHeader = nextHeader;
            return this;
        }

        public Builder hdrExtLen(byte hdrExtLen) {
            this.hdrExtLen = hdrExtLen;
            return this;
        }

        public Builder options(List<IpV6Option> options) {
            this.options = options;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }
    }

    public static abstract class IpV6ExtOptionsHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 224822728201337667L;
        private static final int NEXT_HEADER_OFFSET = 0;
        private static final int NEXT_HEADER_SIZE = 1;
        private static final int HDR_EXT_LEN_OFFSET = 1;
        private static final int HDR_EXT_LEN_SIZE = 1;
        private static final int OPTIONS_OFFSET = 2;
        private final IpNumber nextHeader;
        private final byte hdrExtLen;
        private final List<IpV6Option> options;

        protected IpV6ExtOptionsHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            IpV6Option newOne;
            if (length < 2) {
                StringBuilder sb2 = new StringBuilder(110);
                sb2.append("The data length of ").append(this.getHeaderName()).append(" is must be more than 1. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb2.toString());
            }
            this.nextHeader = IpNumber.getInstance(ByteArrays.getByte(rawData, 0 + offset));
            this.hdrExtLen = ByteArrays.getByte(rawData, 1 + offset);
            int headerLength = (this.getHdrExtLenAsInt() + 1) * 8;
            if (length < headerLength) {
                StringBuilder sb3 = new StringBuilder(110);
                sb3.append("The data is too short to build an ").append(this.getHeaderName()).append("(").append(headerLength).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb3.toString());
            }
            this.options = new ArrayList<IpV6Option>();
            for (int currentOffsetInHeader = 2; currentOffsetInHeader < headerLength; currentOffsetInHeader += newOne.length()) {
                IpV6OptionType type = IpV6OptionType.getInstance(rawData[currentOffsetInHeader + offset]);
                try {
                    newOne = PacketFactories.getFactory(IpV6Option.class, IpV6OptionType.class).newInstance(rawData, currentOffsetInHeader + offset, headerLength - currentOffsetInHeader, type);
                }
                catch (Exception e10) {
                    break;
                }
                this.options.add(newOne);
            }
        }

        protected IpV6ExtOptionsHeader(Builder builder) {
            int optLength = 0;
            for (IpV6Option o10 : builder.options) {
                optLength += o10.length();
            }
            if ((optLength + 2) % 8 != 0) {
                StringBuilder sb2 = new StringBuilder(200);
                String ls2 = System.getProperty("line.separator");
                sb2.append("options length is invalid.").append(" ([options length] + 2) % 8 must be 0.").append(" options: ").append(ls2);
                for (IpV6Option opt : builder.options) {
                    sb2.append(opt).append(ls2);
                }
                throw new IllegalArgumentException(sb2.toString());
            }
            this.nextHeader = builder.nextHeader;
            this.options = new ArrayList<IpV6Option>(builder.options);
            this.hdrExtLen = builder.correctLengthAtBuild ? (byte)((optLength + 2) / 8 - 1) : builder.hdrExtLen;
        }

        public IpNumber getNextHeader() {
            return this.nextHeader;
        }

        public byte getHdrExtLen() {
            return this.hdrExtLen;
        }

        public int getHdrExtLenAsInt() {
            return 0xFF & this.hdrExtLen;
        }

        public List<IpV6Option> getOptions() {
            return new ArrayList<IpV6Option>(this.options);
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Byte)this.nextHeader.value()));
            rawFields.add(ByteArrays.toByteArray(this.hdrExtLen));
            for (IpV6Option o10 : this.options) {
                rawFields.add(o10.getRawData());
            }
            return rawFields;
        }

        @Override
        public int calcLength() {
            int optLength = 0;
            for (IpV6Option o10 : this.options) {
                optLength += o10.length();
            }
            return optLength + 2;
        }

        @Override
        protected String buildString() {
            StringBuilder sb2 = new StringBuilder();
            String ls2 = System.getProperty("line.separator");
            sb2.append("[").append(this.getHeaderName()).append(" (").append(this.length()).append(" bytes)]").append(ls2);
            sb2.append("  Next Header: ").append(this.nextHeader).append(ls2);
            sb2.append("  Hdr Ext Len: ").append(this.getHdrExtLenAsInt()).append(" (").append((this.getHdrExtLenAsInt() + 1) * 8).append(" [bytes])").append(ls2);
            sb2.append("  Options: ").append(ls2);
            for (IpV6Option opt : this.options) {
                sb2.append("    ").append(opt).append(ls2);
            }
            return sb2.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IpV6ExtOptionsHeader other = (IpV6ExtOptionsHeader)obj;
            return this.nextHeader.equals(other.nextHeader) && this.hdrExtLen == other.hdrExtLen && this.options.equals(other.options);
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.nextHeader.hashCode();
            result = 31 * result + this.hdrExtLen;
            result = 31 * result + this.options.hashCode();
            return result;
        }

        protected abstract String getHeaderName();
    }

    public static interface IpV6Option
    extends Serializable {
        public IpV6OptionType getType();

        public int length();

        public byte[] getRawData();
    }
}

