/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpV6RoutingType;
import org.pcap4j.packet.namednumber.NotApplicable;
import org.pcap4j.util.ByteArrays;

public final class IpV6ExtRoutingPacket
extends AbstractPacket {
    private static final long serialVersionUID = -4408422883412551431L;
    private final IpV6ExtRoutingHeader header;
    private final Packet payload;

    public static IpV6ExtRoutingPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IpV6ExtRoutingPacket(rawData, offset, length);
    }

    private IpV6ExtRoutingPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new IpV6ExtRoutingHeader(rawData, offset, length);
        int payloadLength = length - this.header.length();
        if (payloadLength > 0) {
            Packet nextPacket;
            PacketFactory<Packet, IpNumber> factory = PacketFactories.getFactory(Packet.class, IpNumber.class);
            Class<Packet> nextPacketClass = factory.getTargetClass(this.header.getNextHeader());
            if (nextPacketClass.equals(factory.getTargetClass())) {
                nextPacket = PacketFactories.getFactory(Packet.class, NotApplicable.class).newInstance(rawData, offset + this.header.length(), payloadLength, NotApplicable.UNKNOWN_IP_V6_EXTENSION);
                if (nextPacket instanceof IllegalPacket) {
                    nextPacket = factory.newInstance(rawData, offset + this.header.length(), payloadLength);
                }
            } else {
                nextPacket = factory.newInstance(rawData, offset + this.header.length(), payloadLength, this.header.getNextHeader());
            }
            this.payload = nextPacket;
        } else {
            this.payload = null;
        }
    }

    private IpV6ExtRoutingPacket(Builder builder) {
        if (builder == null || builder.nextHeader == null || builder.data == null) {
            StringBuilder sb2 = new StringBuilder();
            sb2.append("builder: ").append(builder).append(" builder.nextHeader: ").append(builder.nextHeader).append(" builder.data: ").append(builder.data);
            throw new NullPointerException(sb2.toString());
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new IpV6ExtRoutingHeader(builder);
    }

    @Override
    public IpV6ExtRoutingHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder
    implements LengthBuilder<IpV6ExtRoutingPacket> {
        private IpNumber nextHeader;
        private byte hdrExtLen;
        private IpV6RoutingType routingType;
        private byte segmentsLeft;
        private IpV6RoutingData data;
        private Packet.Builder payloadBuilder;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        public Builder(IpV6ExtRoutingPacket packet) {
            this.nextHeader = packet.header.nextHeader;
            this.hdrExtLen = packet.header.hdrExtLen;
            this.routingType = packet.header.routingType;
            this.segmentsLeft = packet.header.segmentsLeft;
            this.data = packet.header.data;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder nextHeader(IpNumber nextHeader) {
            this.nextHeader = nextHeader;
            return this;
        }

        public Builder hdrExtLen(byte hdrExtLen) {
            this.hdrExtLen = hdrExtLen;
            return this;
        }

        public Builder routingType(IpV6RoutingType routingType) {
            this.routingType = routingType;
            return this;
        }

        public Builder segmentsLeft(byte segmentsLeft) {
            this.segmentsLeft = segmentsLeft;
            return this;
        }

        public Builder data(IpV6RoutingData data) {
            this.data = data;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public IpV6ExtRoutingPacket build() {
            return new IpV6ExtRoutingPacket(this);
        }
    }

    public static final class IpV6ExtRoutingHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -72622140516174483L;
        private static final int NEXT_HEADER_OFFSET = 0;
        private static final int NEXT_HEADER_SIZE = 1;
        private static final int HDR_EXT_LEN_OFFSET = 1;
        private static final int HDR_EXT_LEN_SIZE = 1;
        private static final int ROUTING_TYPE_OFFSET = 2;
        private static final int ROUTING_TYPE_SIZE = 1;
        private static final int SEGMENTS_LEFT_OFFSET = 3;
        private static final int SEGMENTS_LEFT_SIZE = 1;
        private static final int TYPE_SPECIFIC_DATA_OFFSET = 4;
        private final IpNumber nextHeader;
        private final byte hdrExtLen;
        private final IpV6RoutingType routingType;
        private final byte segmentsLeft;
        private final IpV6RoutingData data;

        private IpV6ExtRoutingHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 4) {
                StringBuilder sb2 = new StringBuilder(110);
                sb2.append("The data length of IPv6 routing header is must be more than 3. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb2.toString());
            }
            this.nextHeader = IpNumber.getInstance(ByteArrays.getByte(rawData, 0 + offset));
            this.hdrExtLen = ByteArrays.getByte(rawData, 1 + offset);
            int headerLength = (this.getHdrExtLenAsInt() + 1) * 8;
            if (length < headerLength) {
                StringBuilder sb3 = new StringBuilder(110);
                sb3.append("The data is too short to build an IPv6 routing header(").append(headerLength).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb3.toString());
            }
            this.routingType = IpV6RoutingType.getInstance(ByteArrays.getByte(rawData, 2 + offset));
            this.segmentsLeft = ByteArrays.getByte(rawData, 3 + offset);
            this.data = PacketFactories.getFactory(IpV6RoutingData.class, IpV6RoutingType.class).newInstance(rawData, 4 + offset, headerLength - 4, this.routingType);
        }

        private IpV6ExtRoutingHeader(Builder builder) {
            if (builder.data.length() < 4) {
                StringBuilder sb2 = new StringBuilder(100);
                sb2.append("data length must be more than 3. data: ").append(builder.data);
                throw new IllegalArgumentException(sb2.toString());
            }
            if ((builder.data.length() + 4) % 8 != 0) {
                StringBuilder sb3 = new StringBuilder(100);
                sb3.append("(builder.data.length() + 8 ) % 8 must be 0. data: ").append(builder.data);
                throw new IllegalArgumentException(sb3.toString());
            }
            this.nextHeader = builder.nextHeader;
            this.routingType = builder.routingType;
            this.segmentsLeft = builder.segmentsLeft;
            this.data = builder.data;
            this.hdrExtLen = builder.correctLengthAtBuild ? (byte)((this.data.length() + 4) / 8 - 1) : builder.hdrExtLen;
        }

        public IpNumber getNextHeader() {
            return this.nextHeader;
        }

        public byte getHdrExtLen() {
            return this.hdrExtLen;
        }

        public int getHdrExtLenAsInt() {
            return 0xFF & this.hdrExtLen;
        }

        public IpV6RoutingType getRoutingType() {
            return this.routingType;
        }

        public byte getSegmentsLeft() {
            return this.segmentsLeft;
        }

        public int getSegmentsLeftAsInt() {
            return this.segmentsLeft & 0xFF;
        }

        public IpV6RoutingData getData() {
            return this.data;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Byte)this.nextHeader.value()));
            rawFields.add(ByteArrays.toByteArray(this.hdrExtLen));
            rawFields.add(ByteArrays.toByteArray((Byte)this.routingType.value()));
            rawFields.add(ByteArrays.toByteArray(this.segmentsLeft));
            rawFields.add(this.data.getRawData());
            return rawFields;
        }

        @Override
        public int calcLength() {
            return this.data.length() + 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb2 = new StringBuilder();
            String ls2 = System.getProperty("line.separator");
            sb2.append("[IPv6 Routing Header (").append(this.length()).append(" bytes)]").append(ls2);
            sb2.append("  Next Header: ").append(this.nextHeader).append(ls2);
            sb2.append("  Hdr Ext Len: ").append(this.getHdrExtLenAsInt()).append(" (").append((this.getHdrExtLenAsInt() + 1) * 8).append(" [bytes])").append(ls2);
            sb2.append("  Routing Type: ").append(this.routingType).append(ls2);
            sb2.append("  Segments Left: ").append(this.getSegmentsLeftAsInt()).append(ls2);
            sb2.append("  type-specific data: ").append(this.data).append(ls2);
            return sb2.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IpV6ExtRoutingHeader other = (IpV6ExtRoutingHeader)obj;
            return this.nextHeader.equals(other.nextHeader) && this.data.equals(other.data) && this.routingType.equals(other.routingType) && this.segmentsLeft == other.segmentsLeft && this.hdrExtLen == other.hdrExtLen;
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.nextHeader.hashCode();
            result = 31 * result + this.hdrExtLen;
            result = 31 * result + this.routingType.hashCode();
            result = 31 * result + this.segmentsLeft;
            result = 31 * result + this.data.hashCode();
            return result;
        }
    }

    public static interface IpV6RoutingData
    extends Serializable {
        public int length();

        public byte[] getRawData();
    }
}

