/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.namednumber.IpV6NeighborDiscoveryOptionType;
import org.pcap4j.util.ByteArrays;

public final class IpV6NeighborDiscoveryMtuOption
implements IcmpV6CommonPacket.IpV6NeighborDiscoveryOption {
    private static final long serialVersionUID = 4145831782727036195L;
    private static final int TYPE_OFFSET = 0;
    private static final int TYPE_SIZE = 1;
    private static final int LENGTH_OFFSET = 1;
    private static final int LENGTH_SIZE = 1;
    private static final int RESERVED_OFFSET = 2;
    private static final int RESERVED_SIZE = 2;
    private static final int MTU_OFFSET = 4;
    private static final int MTU_SIZE = 4;
    private static final int IPV6_NEIGHBOR_DISCOVERY_MTU_OPTION_SIZE = 8;
    private final IpV6NeighborDiscoveryOptionType type = IpV6NeighborDiscoveryOptionType.MTU;
    private final byte length;
    private final short reserved;
    private final int mtu;

    public static IpV6NeighborDiscoveryMtuOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IpV6NeighborDiscoveryMtuOption(rawData, offset, length);
    }

    private IpV6NeighborDiscoveryMtuOption(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 8) {
            StringBuilder sb2 = new StringBuilder(50);
            sb2.append("The raw data length must be more than 7. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb2.toString());
        }
        if (rawData[0 + offset] != (Byte)this.getType().value()) {
            StringBuilder sb3 = new StringBuilder(100);
            sb3.append("The type must be: ").append(this.getType().valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb3.toString());
        }
        this.length = rawData[1 + offset];
        int lengthFieldAsInt = this.getLengthAsInt();
        if (lengthFieldAsInt * 8 != 8) {
            StringBuilder sb4 = new StringBuilder(50);
            sb4.append("Illegal value in the length field: ").append(lengthFieldAsInt);
            throw new IllegalRawDataException(sb4.toString());
        }
        this.reserved = ByteArrays.getShort(rawData, 2 + offset);
        this.mtu = ByteArrays.getInt(rawData, 4 + offset);
    }

    private IpV6NeighborDiscoveryMtuOption(Builder builder) {
        if (builder == null) {
            StringBuilder sb2 = new StringBuilder();
            sb2.append("builder: ").append(builder);
            throw new NullPointerException(sb2.toString());
        }
        this.reserved = builder.reserved;
        this.mtu = builder.mtu;
        this.length = builder.correctLengthAtBuild ? (byte)(this.length() / 8) : builder.length;
    }

    @Override
    public IpV6NeighborDiscoveryOptionType getType() {
        return this.type;
    }

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public short getReserved() {
        return this.reserved;
    }

    public int getMtu() {
        return this.mtu;
    }

    public long getMtuAsLong() {
        return (long)this.mtu & 0xFFFFFFFFL;
    }

    @Override
    public int length() {
        return 8;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getType().value();
        rawData[1] = this.length;
        System.arraycopy(ByteArrays.toByteArray(this.reserved), 0, rawData, 2, 2);
        System.arraycopy(ByteArrays.toByteArray(this.mtu), 0, rawData, 4, 4);
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("[Type: ").append(this.getType());
        sb2.append("] [Length: ").append(this.getLengthAsInt()).append(" (").append(this.getLengthAsInt() * 8);
        sb2.append(" bytes)] [Reserved: ").append(this.reserved);
        sb2.append("] [MTU: ").append(this.getMtuAsLong());
        sb2.append("]");
        return sb2.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IpV6NeighborDiscoveryMtuOption other = (IpV6NeighborDiscoveryMtuOption)obj;
        return this.mtu == other.mtu && this.length == other.length && this.reserved == other.reserved;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.length;
        result = 31 * result + this.reserved;
        result = 31 * result + this.mtu;
        return result;
    }

    public static final class Builder
    implements LengthBuilder<IpV6NeighborDiscoveryMtuOption> {
        private byte length;
        private short reserved;
        private int mtu;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(IpV6NeighborDiscoveryMtuOption option) {
            this.length = option.length;
            this.reserved = option.reserved;
            this.mtu = option.mtu;
        }

        public Builder length(byte length) {
            this.length = length;
            return this;
        }

        public Builder reserved(short reserved) {
            this.reserved = reserved;
            return this;
        }

        public Builder mtu(int mtu) {
            this.mtu = mtu;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public IpV6NeighborDiscoveryMtuOption build() {
            return new IpV6NeighborDiscoveryMtuOption(this);
        }
    }
}

