/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6ExtOptionsPacket;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.namednumber.IpV6OptionType;
import org.pcap4j.util.ByteArrays;

public final class IpV6PadNOption
implements IpV6ExtOptionsPacket.IpV6Option {
    private static final long serialVersionUID = 2182260121605325195L;
    private static final IpV6OptionType type = IpV6OptionType.getInstance((byte)1);
    private final byte dataLen;
    private final byte[] data;

    public static IpV6PadNOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IpV6PadNOption(rawData, offset, length);
    }

    private IpV6PadNOption(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 2) {
            StringBuilder sb2 = new StringBuilder(100);
            sb2.append("The raw data length must be more than 1. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb2.toString());
        }
        if (rawData[offset] != (Byte)type.value()) {
            StringBuilder sb3 = new StringBuilder(100);
            sb3.append("The type must be: ").append(type.valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb3.toString());
        }
        this.dataLen = rawData[1 + offset];
        int dataLenAsInt = this.getDataLenAsInt();
        if (dataLenAsInt > length - 2) {
            StringBuilder sb4 = new StringBuilder(100);
            sb4.append("rawData is too short. dataLen field: ").append(dataLenAsInt).append(", rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb4.toString());
        }
        this.data = ByteArrays.getSubArray(rawData, 2 + offset, dataLenAsInt);
    }

    private IpV6PadNOption(Builder builder) {
        if (builder == null || builder.data == null) {
            StringBuilder sb2 = new StringBuilder();
            sb2.append("builder: ").append(builder).append(" builder.data: ").append(builder.data);
            throw new NullPointerException(sb2.toString());
        }
        this.data = new byte[builder.data.length];
        System.arraycopy(builder.data, 0, this.data, 0, builder.data.length);
        this.dataLen = builder.correctLengthAtBuild ? (byte)this.data.length : builder.dataLen;
    }

    @Override
    public IpV6OptionType getType() {
        return type;
    }

    public byte getDataLen() {
        return this.dataLen;
    }

    public int getDataLenAsInt() {
        return 0xFF & this.dataLen;
    }

    public byte[] getData() {
        byte[] copy = new byte[this.data.length];
        System.arraycopy(this.data, 0, copy, 0, this.data.length);
        return copy;
    }

    @Override
    public int length() {
        return this.data.length + 2;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)type.value();
        rawData[1] = this.dataLen;
        System.arraycopy(this.data, 0, rawData, 2, this.data.length);
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("[Option Type: ").append(type).append("] [Option Data Len: ").append(this.getDataLenAsInt()).append(" bytes] [Option Data: 0x").append(ByteArrays.toHexString(this.data, "")).append("]");
        return sb2.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IpV6PadNOption other = (IpV6PadNOption)obj;
        return this.dataLen == other.dataLen && Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.dataLen;
        result = 31 * Arrays.hashCode(this.data);
        return result;
    }

    public static final class Builder
    implements LengthBuilder<IpV6PadNOption> {
        private byte dataLen;
        private byte[] data;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(IpV6PadNOption option) {
            this.dataLen = option.dataLen;
            this.data = option.data;
        }

        public Builder dataLen(byte dataLen) {
            this.dataLen = dataLen;
            return this;
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public IpV6PadNOption build() {
            return new IpV6PadNOption(this);
        }
    }
}

