/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet6Address;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6ExtRoutingPacket;
import org.pcap4j.util.ByteArrays;

public final class IpV6RoutingSourceRouteData
implements IpV6ExtRoutingPacket.IpV6RoutingData {
    private static final long serialVersionUID = -7972526977248222954L;
    private final int reserved;
    private final List<Inet6Address> addresses;

    public static IpV6RoutingSourceRouteData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IpV6RoutingSourceRouteData(rawData, offset, length);
    }

    private IpV6RoutingSourceRouteData(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 4) {
            StringBuilder sb2 = new StringBuilder(100);
            sb2.append("rawData length must be more than 3. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb2.toString());
        }
        if ((length - 4) % 16 != 0) {
            StringBuilder sb3 = new StringBuilder(100);
            sb3.append("(length -4 ) % ").append(16).append(" must be 0. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb3.toString());
        }
        this.reserved = ByteArrays.getInt(rawData, offset);
        this.addresses = new ArrayList<Inet6Address>();
        for (int i10 = 4; i10 < length; i10 += 16) {
            this.addresses.add(ByteArrays.getInet6Address(rawData, i10 + offset));
        }
    }

    public IpV6RoutingSourceRouteData(int reserved, List<Inet6Address> addresses) {
        if (addresses == null) {
            throw new NullPointerException("addresses must not be null");
        }
        this.reserved = reserved;
        this.addresses = new ArrayList<Inet6Address>(addresses);
    }

    @Override
    public int length() {
        return this.addresses.size() * 16 + 4;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        System.arraycopy(ByteArrays.toByteArray(this.reserved), 0, rawData, 0, 4);
        Iterator<Inet6Address> iter = this.addresses.iterator();
        for (int i10 = 4; i10 < rawData.length; i10 += 16) {
            System.arraycopy(ByteArrays.toByteArray(iter.next()), 0, rawData, i10, 16);
        }
        return rawData;
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("[reserved: ").append(this.reserved).append("] [addresses:");
        for (Inet6Address addr : this.addresses) {
            sb2.append(" ").append(addr);
        }
        sb2.append("]");
        return sb2.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IpV6RoutingSourceRouteData other = (IpV6RoutingSourceRouteData)obj;
        return this.reserved == other.reserved && this.addresses.equals(other.addresses);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.reserved;
        result = 31 * result + this.addresses.hashCode();
        return result;
    }
}

