/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.ArpHardwareType;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.LinuxSllPacketType;
import org.pcap4j.util.ByteArrays;
import org.pcap4j.util.LinkLayerAddress;

public final class LinuxSllPacket
extends AbstractPacket {
    private static final long serialVersionUID = -7743587634024281470L;
    private final LinuxSllHeader header;
    private final Packet payload;

    public static LinuxSllPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new LinuxSllPacket(rawData, offset, length);
    }

    private LinuxSllPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new LinuxSllHeader(rawData, offset, length);
        int payloadLength = length - this.header.length();
        this.payload = payloadLength > 0 ? PacketFactories.getFactory(Packet.class, EtherType.class).newInstance(rawData, offset + this.header.length(), payloadLength, this.header.getProtocol()) : null;
    }

    private LinuxSllPacket(Builder builder) {
        if (builder == null || builder.packetType == null || builder.addressType == null || builder.address == null || builder.protocol == null) {
            StringBuilder sb2 = new StringBuilder();
            sb2.append("builder: ").append(builder).append(" builder.packetType: ").append(builder.packetType).append(" builder.addressType: ").append(builder.addressType).append(" builder.address: ").append(builder.address).append(" builder.protocol: ").append(builder.protocol);
            throw new NullPointerException(sb2.toString());
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new LinuxSllHeader(builder);
    }

    @Override
    public LinuxSllHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private LinuxSllPacketType packetType;
        private ArpHardwareType addressType;
        private short addressLength;
        private byte[] address;
        private EtherType protocol;
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        private Builder(LinuxSllPacket packet) {
            this.packetType = packet.header.packetType;
            this.addressType = packet.header.addressType;
            this.addressLength = packet.header.addressLength;
            this.address = packet.header.addressField;
            this.protocol = packet.header.protocol;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder packetType(LinuxSllPacketType packetType) {
            this.packetType = packetType;
            return this;
        }

        public Builder addressType(ArpHardwareType addressType) {
            this.addressType = addressType;
            return this;
        }

        public Builder addressLength(short addressLength) {
            this.addressLength = addressLength;
            return this;
        }

        public Builder address(byte[] address) {
            this.address = address;
            return this;
        }

        public Builder protocol(EtherType protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        @Override
        public LinuxSllPacket build() {
            return new LinuxSllPacket(this);
        }
    }

    public static final class LinuxSllHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -4946840737268934876L;
        private static final int PPKTTYPE_OFFSET = 0;
        private static final int PPKTTYPE_SIZE = 2;
        private static final int PHATYPE_OFFSET = 2;
        private static final int PHATYPE_SIZE = 2;
        private static final int HALEN_OFFSET = 4;
        private static final int HALEN_SIZE = 2;
        private static final int ADDR_OFFSET = 6;
        private static final int ADDR_SIZE = 8;
        private static final int PROTOCOL_OFFSET = 14;
        private static final int PROTOCOL_SIZE = 2;
        private static final int LINUX_SLL_HEADER_SIZE = 16;
        private final LinuxSllPacketType packetType;
        private final ArpHardwareType addressType;
        private final short addressLength;
        private final byte[] addressField = new byte[8];
        private final LinkLayerAddress address;
        private final EtherType protocol;

        private LinuxSllHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 16) {
                StringBuilder sb2 = new StringBuilder(200);
                sb2.append("The data is too short to build a Linux SLL header(").append(16).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb2.toString());
            }
            this.packetType = LinuxSllPacketType.getInstance(ByteArrays.getShort(rawData, 0 + offset));
            this.addressType = ArpHardwareType.getInstance(ByteArrays.getShort(rawData, 2 + offset));
            this.addressLength = ByteArrays.getShort(rawData, 4 + offset);
            if (this.getAddressLengthAsInt() > 8) {
                StringBuilder sb3 = new StringBuilder(100);
                sb3.append("addressLength must not be longer than ").append(8).append(" but it is: ").append(this.getAddressLengthAsInt());
                throw new IllegalRawDataException(sb3.toString());
            }
            System.arraycopy(rawData, 6 + offset, this.addressField, 0, 8);
            this.address = this.addressLength == 0 ? null : ByteArrays.getLinkLayerAddress(rawData, 6 + offset, this.getAddressLengthAsInt());
            this.protocol = EtherType.getInstance(ByteArrays.getShort(rawData, 14 + offset));
        }

        private LinuxSllHeader(Builder builder) {
            if (builder.address.length > 8) {
                StringBuilder sb2 = new StringBuilder(100);
                sb2.append("address must not be longer than ").append(8).append(" but it is: ").append(ByteArrays.toHexString(builder.address, " "));
                throw new IllegalArgumentException(sb2.toString());
            }
            if ((builder.addressLength & 0xFFFF) > 8) {
                StringBuilder sb3 = new StringBuilder(100);
                sb3.append("addressLength & 0xFFFF must not be longer than ").append(8).append(" but it is: ").append(builder.addressLength & 0xFFFF);
                throw new IllegalArgumentException(sb3.toString());
            }
            this.packetType = builder.packetType;
            this.addressType = builder.addressType;
            this.addressLength = builder.addressLength;
            System.arraycopy(builder.address, 0, this.addressField, 0, builder.address.length);
            this.protocol = builder.protocol;
            this.address = this.addressLength == 0 ? null : ByteArrays.getLinkLayerAddress(this.addressField, 0, this.getAddressLengthAsInt());
        }

        public LinuxSllPacketType getPacketType() {
            return this.packetType;
        }

        public ArpHardwareType getAddressType() {
            return this.addressType;
        }

        public short getAddressLength() {
            return this.addressLength;
        }

        public int getAddressLengthAsInt() {
            return 0xFFFF & this.addressLength;
        }

        public LinkLayerAddress getAddress() {
            return this.address;
        }

        public byte[] getAddressField() {
            return ByteArrays.clone(this.addressField);
        }

        public EtherType getProtocol() {
            return this.protocol;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Short)this.packetType.value()));
            rawFields.add(ByteArrays.toByteArray((Short)this.addressType.value()));
            rawFields.add(ByteArrays.toByteArray(this.addressLength));
            rawFields.add(this.addressField);
            rawFields.add(ByteArrays.toByteArray((Short)this.protocol.value()));
            return rawFields;
        }

        @Override
        public int length() {
            return 16;
        }

        @Override
        protected String buildString() {
            StringBuilder sb2 = new StringBuilder();
            String ls2 = System.getProperty("line.separator");
            sb2.append("[Linux SLL header (").append(this.length()).append(" bytes)]").append(ls2);
            sb2.append("  Packet Type: ").append(this.packetType).append(ls2);
            sb2.append("  Address Type: ").append(this.addressType).append(ls2);
            sb2.append("  Address Length: ").append(this.getAddressLengthAsInt()).append(ls2);
            sb2.append("  Address: ").append(this.address).append(" (").append(ByteArrays.toHexString(this.addressField, " ")).append(")").append(ls2);
            sb2.append("  Protocol: ").append(this.protocol).append(ls2);
            return sb2.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            LinuxSllHeader other = (LinuxSllHeader)obj;
            return Arrays.equals(this.addressField, other.addressField) && this.packetType.equals(other.packetType) && this.protocol.equals(other.protocol) && this.addressType.equals(other.addressType) && this.addressLength == other.addressLength;
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.packetType.hashCode();
            result = 31 * result + this.addressType.hashCode();
            result = 31 * result + this.addressLength;
            result = 31 * result + Arrays.hashCode(this.addressField);
            result = 31 * result + this.protocol.hashCode();
            return result;
        }
    }
}

