/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class Ssh2NameList
implements Serializable {
    private static final long serialVersionUID = 8625201821104360377L;
    private final int length;
    private final List<String> list;

    public Ssh2NameList(List<String> list) {
        if (list == null) {
            throw new NullPointerException("list may not be null");
        }
        this.list = new ArrayList<String>(list);
        this.length = this.calcLength();
    }

    public Ssh2NameList(String ... names) {
        this.list = new ArrayList<String>();
        for (String name : names) {
            this.list.add(name);
        }
        this.length = this.calcLength();
    }

    public Ssh2NameList(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        if (length < 4) {
            StringBuilder sb2 = new StringBuilder(100);
            sb2.append("The rawData length must be more than 3. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb2.toString());
        }
        this.length = ByteArrays.getInt(rawData, offset);
        if (this.length < 0) {
            StringBuilder sb3 = new StringBuilder(120);
            sb3.append("A name-list the length of which is longer than 2147483647 is not supported. length: ").append((long)this.length & 0xFFFFFFFFL);
            throw new IllegalRawDataException(sb3.toString());
        }
        if (length - 4 < this.length) {
            StringBuilder sb4 = new StringBuilder(110);
            sb4.append("The data is too short to build an Ssh2NameList (").append(this.length + 4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb4.toString());
        }
        String nameList = new String(rawData, 4 + offset, this.length);
        this.list = Arrays.asList(nameList.split(","));
    }

    private int calcLength() {
        int len = 0;
        Iterator<String> iter = this.list.iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            len += name.length();
            if (!iter.hasNext()) continue;
            ++len;
        }
        return len;
    }

    public int getLength() {
        return this.length;
    }

    public List<String> getList() {
        return new ArrayList<String>(this.list);
    }

    public int length() {
        return this.getRawData().length;
    }

    public byte[] getRawData() {
        String csv = this.toString();
        byte[] rawData = new byte[csv.length() + 4];
        System.arraycopy(ByteArrays.toByteArray(this.length), 0, rawData, 0, 4);
        System.arraycopy(csv.getBytes(), 0, rawData, 4, csv.length());
        return rawData;
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder(this.length);
        Iterator<String> iter = this.list.iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            sb2.append(name);
            if (!iter.hasNext()) continue;
            sb2.append(",");
        }
        return sb2.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        Ssh2NameList other = (Ssh2NameList)obj;
        return this.length == other.length && this.list.equals(other.list);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.length;
        result = 31 * result + this.list.hashCode();
        return result;
    }
}

