/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class Ssh2String
implements Serializable {
    private static final long serialVersionUID = -1591381991570120515L;
    private final int length;
    private final byte[] string;

    public Ssh2String(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        if (length < 4) {
            StringBuilder sb2 = new StringBuilder(100);
            sb2.append("The rawData length must be more than 3. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb2.toString());
        }
        this.length = ByteArrays.getInt(rawData, offset);
        if (this.length < 0) {
            StringBuilder sb3 = new StringBuilder(120);
            sb3.append("A string the length of which is longer than 2147483647 is not supported. length: ").append((long)this.length & 0xFFFFFFFFL);
            throw new IllegalRawDataException(sb3.toString());
        }
        if (length - 4 < this.length) {
            StringBuilder sb4 = new StringBuilder(110);
            sb4.append("The data is too short to build an Ssh2String (").append(this.length + 4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb4.toString());
        }
        this.string = ByteArrays.getSubArray(rawData, 4 + offset, this.length);
    }

    public Ssh2String(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        try {
            this.string = str.getBytes("UTF-8");
            this.length = this.string.length;
        }
        catch (UnsupportedEncodingException e10) {
            throw new AssertionError((Object)"Never get here.");
        }
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getString() {
        return ByteArrays.clone(this.string);
    }

    public String getStringAsString() {
        try {
            return new String(this.string, "UTF-8");
        }
        catch (UnsupportedEncodingException e10) {
            throw new AssertionError((Object)"Never get here.");
        }
    }

    public int length() {
        return this.length + 4;
    }

    public byte[] getRawData() {
        byte[] rawData = new byte[this.length + 4];
        System.arraycopy(ByteArrays.toByteArray(this.length), 0, rawData, 0, 4);
        System.arraycopy(this.string, 0, rawData, 4, this.length);
        return rawData;
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder(50);
        sb2.append(this.getStringAsString()).append(" (").append(ByteArrays.toHexString(this.string, " ")).append(")");
        return sb2.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        Ssh2String other = (Ssh2String)obj;
        return this.length == other.length && Arrays.equals(this.string, other.string);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.length;
        result = 31 * result + Arrays.hashCode(this.string);
        return result;
    }
}

