/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.factory.PacketInstantiater;
import org.pcap4j.packet.namednumber.NamedNumber;

public abstract class AbstractStaticPacketFactory<N extends NamedNumber<?, ?>>
implements PacketFactory<Packet, N> {
    protected final Map<N, PacketInstantiater> instantiaters = new HashMap<N, PacketInstantiater>();

    @Override
    public Packet newInstance(byte[] rawData, int offset, int length, N number) {
        if (rawData == null || number == null) {
            StringBuilder sb2 = new StringBuilder(40);
            sb2.append("rawData: ").append(rawData).append(" number: ").append(number);
            throw new NullPointerException(sb2.toString());
        }
        PacketInstantiater instantiater = this.instantiaters.get(number);
        if (instantiater != null) {
            try {
                return instantiater.newInstance(rawData, offset, length);
            }
            catch (IllegalRawDataException e10) {
                return IllegalPacket.newPacket(rawData, offset, length);
            }
        }
        return this.newInstance(rawData, offset, length);
    }

    @Override
    public Packet newInstance(byte[] rawData, int offset, int length) {
        return UnknownPacket.newPacket(rawData, offset, length);
    }

    @Override
    public Class<? extends Packet> getTargetClass(N number) {
        if (number == null) {
            throw new NullPointerException("number must not be null.");
        }
        PacketInstantiater pi2 = this.instantiaters.get(number);
        return pi2 != null ? pi2.getTargetClass() : this.getTargetClass();
    }

    @Override
    public Class<? extends Packet> getTargetClass() {
        return UnknownPacket.class;
    }
}

