/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import com.sun.jna.Platform;
import java.util.HashMap;
import java.util.Map;
import org.pcap4j.Pcap4jPropertiesLoader;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class DataLinkType
extends NamedNumber<Integer, DataLinkType> {
    private static final long serialVersionUID = -4299486028394578120L;
    public static final DataLinkType NULL = new DataLinkType(0, "Null");
    public static final DataLinkType EN10MB = new DataLinkType(1, "Ethernet");
    public static final DataLinkType IEEE802 = new DataLinkType(6, "Token Ring");
    public static final DataLinkType PPP = new DataLinkType(9, "PPP");
    public static final DataLinkType FDDI = new DataLinkType(10, "FDDI");
    public static final DataLinkType RAW;
    public static final DataLinkType PPP_SERIAL;
    public static final DataLinkType IEEE802_11;
    public static final DataLinkType LINUX_SLL;
    public static final DataLinkType DOCSIS;
    private static final Map<Integer, DataLinkType> registry;

    public DataLinkType(Integer value, String name) {
        super(value, name);
    }

    public static DataLinkType getInstance(Integer value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new DataLinkType(value, "unknown");
    }

    public static DataLinkType register(DataLinkType type) {
        return registry.put((Integer)type.value(), type);
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Integer)this.value() & 0xFFFF);
    }

    @Override
    public int compareTo(DataLinkType o10) {
        return ((Integer)this.value()).compareTo((Integer)o10.value());
    }

    static {
        PPP_SERIAL = new DataLinkType(50, "PPP over serial with HDLC encapsulation");
        IEEE802_11 = new DataLinkType(105, "Wireless");
        LINUX_SLL = new DataLinkType(113, "Linux cooked-mode capture");
        DOCSIS = new DataLinkType(143, "DOCSIS");
        registry = new HashMap<Integer, DataLinkType>(15);
        Integer raw = Pcap4jPropertiesLoader.getInstance().getDltRaw();
        RAW = raw != null ? new DataLinkType(raw, "RAW") : (Platform.isOpenBSD() ? new DataLinkType(14, "RAW") : new DataLinkType(12, "RAW"));
        registry.put((Integer)NULL.value(), NULL);
        registry.put((Integer)EN10MB.value(), EN10MB);
        registry.put((Integer)IEEE802.value(), IEEE802);
        registry.put((Integer)PPP.value(), PPP);
        registry.put((Integer)FDDI.value(), FDDI);
        registry.put((Integer)RAW.value(), RAW);
        registry.put((Integer)PPP_SERIAL.value(), PPP_SERIAL);
        registry.put((Integer)IEEE802_11.value(), IEEE802_11);
        registry.put((Integer)LINUX_SLL.value(), LINUX_SLL);
        registry.put((Integer)DOCSIS.value(), DOCSIS);
    }
}

