/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.IcmpV4Type;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class IcmpV4Code
extends NamedNumber<Byte, IcmpV4Code> {
    private static final long serialVersionUID = 7592798859079852877L;
    public static final IcmpV4Code NO_CODE = new IcmpV4Code((byte)0, "No Code");
    public static final IcmpV4Code NETWORK_UNREACHABLE = new IcmpV4Code((byte)0, "Network Unreachable");
    public static final IcmpV4Code HOST_UNREACHABLE = new IcmpV4Code((byte)1, "Host Unreachable");
    public static final IcmpV4Code PROTOCOL_UNREACHABLE = new IcmpV4Code((byte)2, "Protocol Unreachable");
    public static final IcmpV4Code PORT_UNREACHABLE = new IcmpV4Code((byte)3, "Port Unreachable");
    public static final IcmpV4Code FRAGMENTATION_BLOCKED = new IcmpV4Code((byte)4, "Fragmentation needed but no fragment bit set");
    public static final IcmpV4Code SRC_ROUTE_FAILED = new IcmpV4Code((byte)5, "Source routing failed");
    public static final IcmpV4Code DST_NETWORK_UNKNOWN = new IcmpV4Code((byte)6, "Destination network unknown");
    public static final IcmpV4Code DST_HOST_UNKNOWN = new IcmpV4Code((byte)7, "Destination host unknown");
    public static final IcmpV4Code SRC_HOST_ISOLATED = new IcmpV4Code((byte)8, "Source host isolated");
    public static final IcmpV4Code DST_NETWORK_PROHIBITED = new IcmpV4Code((byte)9, "Destination network administratively prohibited");
    public static final IcmpV4Code DST_HOST_PROHIBITED = new IcmpV4Code((byte)10, "Destination host administratively prohibited");
    public static final IcmpV4Code DST_NETWORK_UNREACHABLE_FOR_TOS = new IcmpV4Code((byte)11, "Network unreachable for TOS");
    public static final IcmpV4Code DST_HOST_UNREACHABLE_FOR_TOS = new IcmpV4Code((byte)12, "Host unreachable for TOS");
    public static final IcmpV4Code COMMUNICATION_PROHIBITED = new IcmpV4Code((byte)13, "Communication administratively prohibited by filtering");
    public static final IcmpV4Code HOST_PRECEDENCE_VIOLATION = new IcmpV4Code((byte)14, "Host precedence violation");
    public static final IcmpV4Code PRECEDENCE_CUTOFF_IN_EFFECT = new IcmpV4Code((byte)15, "Precedence cutoff in effect");
    public static final IcmpV4Code REDIRECT_DATAGRAMS_FOR_NETWORK = new IcmpV4Code((byte)0, "Redirect datagrams for the Network");
    public static final IcmpV4Code REDIRECT_DATAGRAMS_FOR_HOST = new IcmpV4Code((byte)1, "Redirect datagrams for the Host");
    public static final IcmpV4Code REDIRECT_DATAGRAMS_FOR_TOS_AND_NETWORK = new IcmpV4Code((byte)2, "Redirect datagrams for the Type of Service and Network");
    public static final IcmpV4Code REDIRECT_DATAGRAMS_FOR_TOS_AND_HOST = new IcmpV4Code((byte)3, "Redirect datagrams for the Type of Service and Host");
    public static final IcmpV4Code ALTERNATE_ADDRESS_FOR_HOST = new IcmpV4Code((byte)0, "Alternate Address for Host");
    public static final IcmpV4Code NORMAL_ROUTER_ADVERTISEMENT = new IcmpV4Code((byte)0, "Normal router advertisement");
    public static final IcmpV4Code DOES_NOT_ROUTE_COMMON_TRAFFIC = new IcmpV4Code((byte)16, "Does not route common traffic");
    public static final IcmpV4Code TIME_TO_LIVE_EXCEEDED = new IcmpV4Code((byte)0, "Time to Live exceeded during transit");
    public static final IcmpV4Code FRAGMENT_REASSEMBLY_TIME_EXCEEDED = new IcmpV4Code((byte)1, "Fragment Reassembly Time Exceeded");
    public static final IcmpV4Code POINTER_INDICATES_ERROR = new IcmpV4Code((byte)0, "Pointer indicates the error");
    public static final IcmpV4Code MISSING_REQUIRED_OPTION = new IcmpV4Code((byte)1, "Missing a Required Option");
    public static final IcmpV4Code BAD_LENGTH = new IcmpV4Code((byte)2, "Bad Length");
    public static final IcmpV4Code BAD_SPI = new IcmpV4Code((byte)0, "Bad SPI");
    public static final IcmpV4Code AUTHENTICATION_FAILED = new IcmpV4Code((byte)1, "Authentication Failed");
    public static final IcmpV4Code DECOMPRESSION_FAILED = new IcmpV4Code((byte)2, "Decompression Failed");
    public static final IcmpV4Code DECRYPTION_FAILED = new IcmpV4Code((byte)3, "Decryption Failed");
    public static final IcmpV4Code NEED_AUTHENTICATION = new IcmpV4Code((byte)4, "Need Authentication");
    public static final IcmpV4Code NEED_AUTHORIZATION = new IcmpV4Code((byte)5, "Need Authorization");
    private static final Map<Byte, Map<Byte, IcmpV4Code>> registry = new HashMap<Byte, Map<Byte, IcmpV4Code>>();

    public IcmpV4Code(Byte value, String name) {
        super(value, name);
    }

    public static IcmpV4Code getInstance(Byte type, Byte value) {
        if (registry.containsKey(type) && registry.get(type).containsKey(value)) {
            return registry.get(type).get(value);
        }
        return new IcmpV4Code(value, "unknown");
    }

    public static IcmpV4Code register(IcmpV4Type type, IcmpV4Code code) {
        if (registry.containsKey(type.value())) {
            return registry.get(type.value()).put((Byte)code.value(), code);
        }
        HashMap map = new HashMap();
        map.put(code.value(), code);
        registry.put((Byte)type.value(), map);
        return null;
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    @Override
    public int compareTo(IcmpV4Code o10) {
        return ((Byte)this.value()).compareTo((Byte)o10.value());
    }

    static {
        HashMap map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV4Type.ECHO_REPLY.value(), map);
        map = new HashMap();
        map.put(NETWORK_UNREACHABLE.value(), NETWORK_UNREACHABLE);
        map.put(HOST_UNREACHABLE.value(), HOST_UNREACHABLE);
        map.put(PROTOCOL_UNREACHABLE.value(), PROTOCOL_UNREACHABLE);
        map.put(PORT_UNREACHABLE.value(), PORT_UNREACHABLE);
        map.put(FRAGMENTATION_BLOCKED.value(), FRAGMENTATION_BLOCKED);
        map.put(SRC_ROUTE_FAILED.value(), SRC_ROUTE_FAILED);
        map.put(DST_NETWORK_UNKNOWN.value(), DST_NETWORK_UNKNOWN);
        map.put(DST_HOST_UNKNOWN.value(), DST_HOST_UNKNOWN);
        map.put(SRC_HOST_ISOLATED.value(), SRC_HOST_ISOLATED);
        map.put(DST_NETWORK_PROHIBITED.value(), DST_NETWORK_PROHIBITED);
        map.put(DST_HOST_PROHIBITED.value(), DST_HOST_PROHIBITED);
        map.put(DST_NETWORK_UNREACHABLE_FOR_TOS.value(), DST_NETWORK_UNREACHABLE_FOR_TOS);
        map.put(DST_HOST_UNREACHABLE_FOR_TOS.value(), DST_HOST_UNREACHABLE_FOR_TOS);
        map.put(COMMUNICATION_PROHIBITED.value(), COMMUNICATION_PROHIBITED);
        map.put(HOST_PRECEDENCE_VIOLATION.value(), HOST_PRECEDENCE_VIOLATION);
        map.put(PRECEDENCE_CUTOFF_IN_EFFECT.value(), PRECEDENCE_CUTOFF_IN_EFFECT);
        registry.put((Byte)IcmpV4Type.DESTINATION_UNREACHABLE.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV4Type.SOURCE_QUENCH.value(), map);
        map = new HashMap();
        map.put(REDIRECT_DATAGRAMS_FOR_NETWORK.value(), REDIRECT_DATAGRAMS_FOR_NETWORK);
        map.put(REDIRECT_DATAGRAMS_FOR_HOST.value(), REDIRECT_DATAGRAMS_FOR_HOST);
        map.put(REDIRECT_DATAGRAMS_FOR_TOS_AND_NETWORK.value(), REDIRECT_DATAGRAMS_FOR_TOS_AND_NETWORK);
        map.put(REDIRECT_DATAGRAMS_FOR_TOS_AND_HOST.value(), REDIRECT_DATAGRAMS_FOR_TOS_AND_HOST);
        registry.put((Byte)IcmpV4Type.REDIRECT.value(), map);
        map = new HashMap();
        map.put(ALTERNATE_ADDRESS_FOR_HOST.value(), ALTERNATE_ADDRESS_FOR_HOST);
        registry.put((Byte)IcmpV4Type.ALTERNATE_HOST_ADDRESS.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV4Type.ECHO.value(), map);
        map = new HashMap();
        map.put(NORMAL_ROUTER_ADVERTISEMENT.value(), NORMAL_ROUTER_ADVERTISEMENT);
        map.put(DOES_NOT_ROUTE_COMMON_TRAFFIC.value(), DOES_NOT_ROUTE_COMMON_TRAFFIC);
        registry.put((Byte)IcmpV4Type.ROUTER_ADVERTISEMENT.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV4Type.ROUTER_SOLICITATION.value(), map);
        map = new HashMap();
        map.put(TIME_TO_LIVE_EXCEEDED.value(), TIME_TO_LIVE_EXCEEDED);
        map.put(FRAGMENT_REASSEMBLY_TIME_EXCEEDED.value(), FRAGMENT_REASSEMBLY_TIME_EXCEEDED);
        registry.put((Byte)IcmpV4Type.TIME_EXCEEDED.value(), map);
        map = new HashMap();
        map.put(POINTER_INDICATES_ERROR.value(), POINTER_INDICATES_ERROR);
        map.put(MISSING_REQUIRED_OPTION.value(), MISSING_REQUIRED_OPTION);
        map.put(BAD_LENGTH.value(), BAD_LENGTH);
        registry.put((Byte)IcmpV4Type.PARAMETER_PROBLEM.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV4Type.TIMESTAMP.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV4Type.TIMESTAMP_REPLY.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV4Type.INFORMATION_REQUEST.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV4Type.INFORMATION_REPLY.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV4Type.ADDRESS_MASK_REQUEST.value(), map);
        map = new HashMap();
        map.put(NO_CODE.value(), NO_CODE);
        registry.put((Byte)IcmpV4Type.ADDRESS_MASK_REPLY.value(), map);
        map = new HashMap();
        map.put(BAD_SPI.value(), BAD_SPI);
        map.put(AUTHENTICATION_FAILED.value(), AUTHENTICATION_FAILED);
        map.put(DECOMPRESSION_FAILED.value(), DECOMPRESSION_FAILED);
        map.put(DECRYPTION_FAILED.value(), DECRYPTION_FAILED);
        map.put(NEED_AUTHENTICATION.value(), NEED_AUTHENTICATION);
        map.put(NEED_AUTHORIZATION.value(), NEED_AUTHORIZATION);
        registry.put((Byte)IcmpV4Type.PHOTURIS.value(), map);
    }
}

