/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class IcmpV4Type
extends NamedNumber<Byte, IcmpV4Type> {
    private static final long serialVersionUID = -6737808159892354431L;
    public static final IcmpV4Type ECHO_REPLY = new IcmpV4Type((byte)0, "Echo Reply");
    public static final IcmpV4Type DESTINATION_UNREACHABLE = new IcmpV4Type((byte)3, "Destination Unreachable");
    public static final IcmpV4Type SOURCE_QUENCH = new IcmpV4Type((byte)4, "Source Quench");
    public static final IcmpV4Type REDIRECT = new IcmpV4Type((byte)5, "Redirect");
    public static final IcmpV4Type ALTERNATE_HOST_ADDRESS = new IcmpV4Type((byte)6, "Alternate Host Address");
    public static final IcmpV4Type ECHO = new IcmpV4Type((byte)8, "Echo");
    public static final IcmpV4Type ROUTER_ADVERTISEMENT = new IcmpV4Type((byte)9, "Router Advertisement");
    public static final IcmpV4Type ROUTER_SOLICITATION = new IcmpV4Type((byte)10, "Router Solicitation");
    public static final IcmpV4Type TIME_EXCEEDED = new IcmpV4Type((byte)11, "Time Exceeded");
    public static final IcmpV4Type PARAMETER_PROBLEM = new IcmpV4Type((byte)12, "Parameter Problem");
    public static final IcmpV4Type TIMESTAMP = new IcmpV4Type((byte)13, "Timestamp");
    public static final IcmpV4Type TIMESTAMP_REPLY = new IcmpV4Type((byte)14, "Timestamp Reply");
    public static final IcmpV4Type INFORMATION_REQUEST = new IcmpV4Type((byte)15, "Information Request");
    public static final IcmpV4Type INFORMATION_REPLY = new IcmpV4Type((byte)16, "Information Reply");
    public static final IcmpV4Type ADDRESS_MASK_REQUEST = new IcmpV4Type((byte)17, "Address Mask Request");
    public static final IcmpV4Type ADDRESS_MASK_REPLY = new IcmpV4Type((byte)18, "Address Mask Reply");
    public static final IcmpV4Type TRACEROUTE = new IcmpV4Type((byte)30, "Traceroute");
    public static final IcmpV4Type DATAGRAM_CONVERSION_ERROR = new IcmpV4Type((byte)31, "Datagram Conversion Error");
    public static final IcmpV4Type MOBILE_HOST_REDIRECT = new IcmpV4Type((byte)32, "Mobile Host Redirect");
    public static final IcmpV4Type IPV6_WHERE_ARE_YOU = new IcmpV4Type((byte)33, "IPv6 Where-Are-You");
    public static final IcmpV4Type IPV6_I_AM_HERE = new IcmpV4Type((byte)34, "IPv6 I-Am-Here");
    public static final IcmpV4Type MOBILE_REGISTRATION_REQUEST = new IcmpV4Type((byte)35, "Mobile Registration Request");
    public static final IcmpV4Type MOBILE_REGISTRATION_REPLY = new IcmpV4Type((byte)36, "Mobile Registration Reply");
    public static final IcmpV4Type DOMAIN_NAME_REQUEST = new IcmpV4Type((byte)37, "Domain Name Request");
    public static final IcmpV4Type DOMAIN_NAME_REPLY = new IcmpV4Type((byte)38, "Domain Name Reply");
    public static final IcmpV4Type SKIP = new IcmpV4Type((byte)39, "SKIP");
    public static final IcmpV4Type PHOTURIS = new IcmpV4Type((byte)40, "Photuris");
    private static final Map<Byte, IcmpV4Type> registry = new HashMap<Byte, IcmpV4Type>();

    public IcmpV4Type(Byte value, String name) {
        super(value, name);
    }

    public static IcmpV4Type getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new IcmpV4Type(value, "unknown");
    }

    public static IcmpV4Type register(IcmpV4Type type) {
        return registry.put((Byte)type.value(), type);
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    @Override
    public int compareTo(IcmpV4Type o10) {
        return ((Byte)this.value()).compareTo((Byte)o10.value());
    }

    static {
        registry.put((Byte)ECHO_REPLY.value(), ECHO_REPLY);
        registry.put((Byte)DESTINATION_UNREACHABLE.value(), DESTINATION_UNREACHABLE);
        registry.put((Byte)SOURCE_QUENCH.value(), SOURCE_QUENCH);
        registry.put((Byte)REDIRECT.value(), REDIRECT);
        registry.put((Byte)ALTERNATE_HOST_ADDRESS.value(), ALTERNATE_HOST_ADDRESS);
        registry.put((Byte)ECHO.value(), ECHO);
        registry.put((Byte)ROUTER_ADVERTISEMENT.value(), ROUTER_ADVERTISEMENT);
        registry.put((Byte)ROUTER_SOLICITATION.value(), ROUTER_SOLICITATION);
        registry.put((Byte)TIME_EXCEEDED.value(), TIME_EXCEEDED);
        registry.put((Byte)PARAMETER_PROBLEM.value(), PARAMETER_PROBLEM);
        registry.put((Byte)TIMESTAMP.value(), TIMESTAMP);
        registry.put((Byte)TIMESTAMP_REPLY.value(), TIMESTAMP_REPLY);
        registry.put((Byte)INFORMATION_REQUEST.value(), INFORMATION_REQUEST);
        registry.put((Byte)INFORMATION_REPLY.value(), INFORMATION_REPLY);
        registry.put((Byte)ADDRESS_MASK_REQUEST.value(), ADDRESS_MASK_REQUEST);
        registry.put((Byte)ADDRESS_MASK_REPLY.value(), ADDRESS_MASK_REPLY);
        registry.put((Byte)TRACEROUTE.value(), TRACEROUTE);
        registry.put((Byte)DATAGRAM_CONVERSION_ERROR.value(), DATAGRAM_CONVERSION_ERROR);
        registry.put((Byte)MOBILE_HOST_REDIRECT.value(), MOBILE_HOST_REDIRECT);
        registry.put((Byte)IPV6_WHERE_ARE_YOU.value(), IPV6_WHERE_ARE_YOU);
        registry.put((Byte)IPV6_I_AM_HERE.value(), IPV6_I_AM_HERE);
        registry.put((Byte)MOBILE_REGISTRATION_REQUEST.value(), MOBILE_REGISTRATION_REQUEST);
        registry.put((Byte)MOBILE_REGISTRATION_REPLY.value(), MOBILE_REGISTRATION_REPLY);
        registry.put((Byte)DOMAIN_NAME_REQUEST.value(), DOMAIN_NAME_REQUEST);
        registry.put((Byte)DOMAIN_NAME_REPLY.value(), DOMAIN_NAME_REPLY);
        registry.put((Byte)SKIP.value(), SKIP);
        registry.put((Byte)PHOTURIS.value(), PHOTURIS);
    }
}

