/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class IpV4OptionType
extends NamedNumber<Byte, IpV4OptionType> {
    private static final long serialVersionUID = -7033971699970069137L;
    public static final IpV4OptionType END_OF_OPTION_LIST = new IpV4OptionType((byte)0, "End of Option List");
    public static final IpV4OptionType NO_OPERATION = new IpV4OptionType((byte)1, "No Operation");
    public static final IpV4OptionType SECURITY = new IpV4OptionType((byte)-126, "Security");
    public static final IpV4OptionType LOOSE_SOURCE_ROUTING = new IpV4OptionType((byte)-125, "Loose Source Routing");
    public static final IpV4OptionType INTERNET_TIMESTAMP = new IpV4OptionType((byte)68, "Internet Timestamp");
    public static final IpV4OptionType EXTENDED_SECURITY = new IpV4OptionType((byte)-123, "Extended Security");
    public static final IpV4OptionType CIPSO = new IpV4OptionType((byte)-122, "CIPSO");
    public static final IpV4OptionType RECORD_ROUTE = new IpV4OptionType((byte)7, "Record Route");
    public static final IpV4OptionType STREAM_ID = new IpV4OptionType((byte)-120, "Stream ID");
    public static final IpV4OptionType STRICT_SOURCE_ROUTING = new IpV4OptionType((byte)-119, "Strict Source Routing");
    public static final IpV4OptionType ZSU = new IpV4OptionType((byte)10, "ZSU");
    public static final IpV4OptionType MTUP = new IpV4OptionType((byte)11, "MTUP");
    public static final IpV4OptionType MTUR = new IpV4OptionType((byte)12, "MTUR");
    public static final IpV4OptionType FINN = new IpV4OptionType((byte)-51, "FINN");
    public static final IpV4OptionType VISA = new IpV4OptionType((byte)-114, "VISA");
    public static final IpV4OptionType ENCODE = new IpV4OptionType((byte)15, "ENCODE");
    public static final IpV4OptionType IMITD = new IpV4OptionType((byte)-112, "IMITD");
    public static final IpV4OptionType EIP = new IpV4OptionType((byte)-111, "EIP");
    public static final IpV4OptionType TRACEROUTE = new IpV4OptionType((byte)82, "Traceroute");
    public static final IpV4OptionType ADDRESS_EXTENSION = new IpV4OptionType((byte)-109, "Address Extension");
    public static final IpV4OptionType ROUTER_ALERT = new IpV4OptionType((byte)-108, "Router Alert");
    public static final IpV4OptionType SELECTIVE_DIRECTED_BROADCAST = new IpV4OptionType((byte)-107, "Selective Directed Broadcast");
    public static final IpV4OptionType DYNAMIC_PACKET_STATE = new IpV4OptionType((byte)-105, "Dynamic Packet State");
    public static final IpV4OptionType UPSTREAM_MULTICAST_PACKET = new IpV4OptionType((byte)-104, "Upstream Multicast Packet");
    public static final IpV4OptionType QUICK_START = new IpV4OptionType((byte)25, "Quick-Start");
    private static final Map<Byte, IpV4OptionType> registry = new HashMap<Byte, IpV4OptionType>();
    private final boolean copied;
    private final IpV4OptionClass optionClass;
    private final byte number;

    public IpV4OptionType(Byte value, String name) {
        super(value, name);
        this.copied = (value & 0x80) != 0;
        this.number = (byte)(value & 0x1F);
        switch (value & 0x60) {
            case 0: {
                this.optionClass = IpV4OptionClass.CONTROL;
                break;
            }
            case 32: {
                this.optionClass = IpV4OptionClass.RESERVED_FOR_FUTURE_USE1;
                break;
            }
            case 64: {
                this.optionClass = IpV4OptionClass.DEBUGGING_AND_MEASUREMENT;
                break;
            }
            case 96: {
                this.optionClass = IpV4OptionClass.RESERVED_FOR_FUTURE_USE3;
                break;
            }
            default: {
                throw new AssertionError((Object)"Never get here");
            }
        }
    }

    public boolean isCopied() {
        return this.copied;
    }

    public IpV4OptionClass getOptionClass() {
        return this.optionClass;
    }

    public byte getNumber() {
        return this.number;
    }

    public static IpV4OptionType getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new IpV4OptionType(value, "unknown");
    }

    public static IpV4OptionType register(IpV4OptionType type) {
        return registry.put((Byte)type.value(), type);
    }

    @Override
    public int compareTo(IpV4OptionType o10) {
        return ((Byte)this.value()).compareTo((Byte)o10.value());
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    static {
        registry.put((Byte)END_OF_OPTION_LIST.value(), END_OF_OPTION_LIST);
        registry.put((Byte)NO_OPERATION.value(), NO_OPERATION);
        registry.put((Byte)SECURITY.value(), SECURITY);
        registry.put((Byte)LOOSE_SOURCE_ROUTING.value(), LOOSE_SOURCE_ROUTING);
        registry.put((Byte)INTERNET_TIMESTAMP.value(), INTERNET_TIMESTAMP);
        registry.put((Byte)EXTENDED_SECURITY.value(), EXTENDED_SECURITY);
        registry.put((Byte)CIPSO.value(), CIPSO);
        registry.put((Byte)RECORD_ROUTE.value(), RECORD_ROUTE);
        registry.put((Byte)STREAM_ID.value(), STREAM_ID);
        registry.put((Byte)STRICT_SOURCE_ROUTING.value(), STRICT_SOURCE_ROUTING);
        registry.put((Byte)ZSU.value(), ZSU);
        registry.put((Byte)MTUP.value(), MTUP);
        registry.put((Byte)MTUR.value(), MTUR);
        registry.put((Byte)FINN.value(), FINN);
        registry.put((Byte)VISA.value(), VISA);
        registry.put((Byte)ENCODE.value(), ENCODE);
        registry.put((Byte)IMITD.value(), IMITD);
        registry.put((Byte)EIP.value(), EIP);
        registry.put((Byte)TRACEROUTE.value(), TRACEROUTE);
        registry.put((Byte)ADDRESS_EXTENSION.value(), ADDRESS_EXTENSION);
        registry.put((Byte)ROUTER_ALERT.value(), ROUTER_ALERT);
        registry.put((Byte)SELECTIVE_DIRECTED_BROADCAST.value(), SELECTIVE_DIRECTED_BROADCAST);
        registry.put((Byte)DYNAMIC_PACKET_STATE.value(), DYNAMIC_PACKET_STATE);
        registry.put((Byte)UPSTREAM_MULTICAST_PACKET.value(), UPSTREAM_MULTICAST_PACKET);
        registry.put((Byte)QUICK_START.value(), QUICK_START);
    }

    public static enum IpV4OptionClass {
        CONTROL(0),
        RESERVED_FOR_FUTURE_USE1(1),
        DEBUGGING_AND_MEASUREMENT(2),
        RESERVED_FOR_FUTURE_USE3(3);

        private final byte value;

        private IpV4OptionClass(byte value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

