/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.core.Inets;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class ProtocolFamily
extends NamedNumber<Integer, ProtocolFamily> {
    private static final long serialVersionUID = 2803732603678906217L;
    public static final ProtocolFamily PF_UNSPEC = new ProtocolFamily(0, "PF_UNSPEC");
    public static final ProtocolFamily PF_INET = new ProtocolFamily(0xFFFF & Inets.AF_INET, "PF_INET");
    public static final ProtocolFamily PF_LINK = new ProtocolFamily(0xFFFF & Inets.AF_LINK, "PF_LINK");
    public static final ProtocolFamily PF_INET6 = new ProtocolFamily(0xFFFF & Inets.AF_INET6, "PF_INET6");
    private static final Map<Integer, ProtocolFamily> registry = new HashMap<Integer, ProtocolFamily>(10);

    public ProtocolFamily(Integer value, String name) {
        super(value, name);
    }

    public static ProtocolFamily getInstance(Integer value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new ProtocolFamily(value, "unknown");
    }

    public static ProtocolFamily register(ProtocolFamily type) {
        return registry.put((Integer)type.value(), type);
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Integer)this.value() & 0xFFFF);
    }

    @Override
    public int compareTo(ProtocolFamily o10) {
        return ((Integer)this.value()).compareTo((Integer)o10.value());
    }

    static {
        registry.put((Integer)PF_UNSPEC.value(), PF_UNSPEC);
        registry.put((Integer)PF_INET.value(), PF_INET);
        registry.put((Integer)PF_LINK.value(), PF_LINK);
        registry.put((Integer)PF_INET6.value(), PF_INET6);
    }
}

