/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.util;

import org.pcap4j.packet.ChecksumBuilder;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.util.ByteArrays;

public final class IcmpV6Helper {
    private IcmpV6Helper() {
        throw new AssertionError();
    }

    public static Packet makePacketForInvokingPacketField(Packet packet, int size) {
        int length;
        if (packet == null || packet.getHeader() == null || packet.getPayload() == null) {
            StringBuilder sb2 = new StringBuilder();
            sb2.append("packet: ").append(packet).append(" packet.getHeader(): ").append(packet.getHeader()).append(" packet.getPayload(): ").append(packet.getPayload());
            throw new NullPointerException(sb2.toString());
        }
        if (packet.length() <= size) {
            return packet;
        }
        int prelength = length = packet.getHeader().length();
        int pos = 0;
        Packet last = null;
        for (Packet p10 : packet.getPayload()) {
            if (p10.getHeader() != null) {
                prelength = length;
                ++pos;
                if ((length += p10.getHeader().length()) <= size) continue;
                last = p10;
                break;
            }
            prelength = length;
            length += p10.length();
            ++pos;
            last = p10;
            break;
        }
        Packet.Builder resultBuilder = packet.getBuilder();
        for (Packet.Builder b10 : resultBuilder) {
            if (b10 instanceof LengthBuilder) {
                ((LengthBuilder)((Object)b10)).correctLengthAtBuild(false);
            }
            if (b10 instanceof ChecksumBuilder) {
                ((ChecksumBuilder)((Object)b10)).correctChecksumAtBuild(false);
            }
            if (--pos != 0) continue;
            if (size - prelength > 0) {
                b10.payloadBuilder(new UnknownPacket.Builder().rawData(ByteArrays.getSubArray(last.getRawData(), 0, size - prelength)));
                break;
            }
            b10.payloadBuilder(null);
            break;
        }
        return resultBuilder.build();
    }

    public static Packet makePacketForRedirectHeaderOption(Packet packet, int size) {
        if (packet.length() > size) {
            return IcmpV6Helper.makePacketForInvokingPacketField(packet, size - size % 8);
        }
        int length = packet.length();
        return IcmpV6Helper.makePacketForInvokingPacketField(packet, length - length % 8);
    }
}

