/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.helpers.FormattingTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageFormatter {
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    public static final FormattingTuple format(String messagePattern, Object arg) {
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{arg});
    }

    public static final FormattingTuple format(String messagePattern, Object arg1, Object arg2) {
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{arg1, arg2});
    }

    static final Throwable getThrowableCandidate(Object[] argArray) {
        if (argArray == null || argArray.length == 0) {
            return null;
        }
        Object lastEntry = argArray[argArray.length - 1];
        if (lastEntry instanceof Throwable) {
            return (Throwable)lastEntry;
        }
        return null;
    }

    public static final FormattingTuple arrayFormat(String messagePattern, Object[] argArray) {
        int L10;
        Throwable throwableCandidate = MessageFormatter.getThrowableCandidate(argArray);
        if (messagePattern == null) {
            return new FormattingTuple(null, argArray, throwableCandidate);
        }
        if (argArray == null) {
            return new FormattingTuple(messagePattern);
        }
        int i10 = 0;
        StringBuilder sbuf = new StringBuilder(messagePattern.length() + 50);
        for (L10 = 0; L10 < argArray.length; ++L10) {
            int j10 = messagePattern.indexOf(DELIM_STR, i10);
            if (j10 == -1) {
                if (i10 == 0) {
                    return new FormattingTuple(messagePattern, argArray, throwableCandidate);
                }
                sbuf.append(messagePattern.substring(i10, messagePattern.length()));
                return new FormattingTuple(sbuf.toString(), argArray, throwableCandidate);
            }
            if (MessageFormatter.isEscapedDelimeter(messagePattern, j10)) {
                if (!MessageFormatter.isDoubleEscaped(messagePattern, j10)) {
                    --L10;
                    sbuf.append(messagePattern.substring(i10, j10 - 1));
                    sbuf.append('{');
                    i10 = j10 + 1;
                    continue;
                }
                sbuf.append(messagePattern.substring(i10, j10 - 1));
                MessageFormatter.deeplyAppendParameter(sbuf, argArray[L10], new HashMap<Object[], Object>());
                i10 = j10 + 2;
                continue;
            }
            sbuf.append(messagePattern.substring(i10, j10));
            MessageFormatter.deeplyAppendParameter(sbuf, argArray[L10], new HashMap<Object[], Object>());
            i10 = j10 + 2;
        }
        sbuf.append(messagePattern.substring(i10, messagePattern.length()));
        if (L10 < argArray.length - 1) {
            return new FormattingTuple(sbuf.toString(), argArray, throwableCandidate);
        }
        return new FormattingTuple(sbuf.toString(), argArray, null);
    }

    static final boolean isEscapedDelimeter(String messagePattern, int delimeterStartIndex) {
        if (delimeterStartIndex == 0) {
            return false;
        }
        char potentialEscape = messagePattern.charAt(delimeterStartIndex - 1);
        return potentialEscape == '\\';
    }

    static final boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
        return delimeterStartIndex >= 2 && messagePattern.charAt(delimeterStartIndex - 2) == '\\';
    }

    private static void deeplyAppendParameter(StringBuilder sbuf, Object o10, Map<Object[], Object> seenMap) {
        if (o10 == null) {
            sbuf.append("null");
            return;
        }
        if (!o10.getClass().isArray()) {
            MessageFormatter.safeObjectAppend(sbuf, o10);
        } else if (o10 instanceof boolean[]) {
            MessageFormatter.booleanArrayAppend(sbuf, (boolean[])o10);
        } else if (o10 instanceof byte[]) {
            MessageFormatter.byteArrayAppend(sbuf, (byte[])o10);
        } else if (o10 instanceof char[]) {
            MessageFormatter.charArrayAppend(sbuf, (char[])o10);
        } else if (o10 instanceof short[]) {
            MessageFormatter.shortArrayAppend(sbuf, (short[])o10);
        } else if (o10 instanceof int[]) {
            MessageFormatter.intArrayAppend(sbuf, (int[])o10);
        } else if (o10 instanceof long[]) {
            MessageFormatter.longArrayAppend(sbuf, (long[])o10);
        } else if (o10 instanceof float[]) {
            MessageFormatter.floatArrayAppend(sbuf, (float[])o10);
        } else if (o10 instanceof double[]) {
            MessageFormatter.doubleArrayAppend(sbuf, (double[])o10);
        } else {
            MessageFormatter.objectArrayAppend(sbuf, (Object[])o10, seenMap);
        }
    }

    private static void safeObjectAppend(StringBuilder sbuf, Object o10) {
        try {
            String oAsString = o10.toString();
            sbuf.append(oAsString);
        }
        catch (Throwable t10) {
            System.err.println("SLF4J: Failed toString() invocation on an object of type [" + o10.getClass().getName() + "]");
            t10.printStackTrace();
            sbuf.append("[FAILED toString()]");
        }
    }

    private static void objectArrayAppend(StringBuilder sbuf, Object[] a10, Map<Object[], Object> seenMap) {
        sbuf.append('[');
        if (!seenMap.containsKey(a10)) {
            seenMap.put(a10, null);
            int len = a10.length;
            for (int i10 = 0; i10 < len; ++i10) {
                MessageFormatter.deeplyAppendParameter(sbuf, a10[i10], seenMap);
                if (i10 == len - 1) continue;
                sbuf.append(", ");
            }
            seenMap.remove(a10);
        } else {
            sbuf.append("...");
        }
        sbuf.append(']');
    }

    private static void booleanArrayAppend(StringBuilder sbuf, boolean[] a10) {
        sbuf.append('[');
        int len = a10.length;
        for (int i10 = 0; i10 < len; ++i10) {
            sbuf.append(a10[i10]);
            if (i10 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void byteArrayAppend(StringBuilder sbuf, byte[] a10) {
        sbuf.append('[');
        int len = a10.length;
        for (int i10 = 0; i10 < len; ++i10) {
            sbuf.append(a10[i10]);
            if (i10 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void charArrayAppend(StringBuilder sbuf, char[] a10) {
        sbuf.append('[');
        int len = a10.length;
        for (int i10 = 0; i10 < len; ++i10) {
            sbuf.append(a10[i10]);
            if (i10 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void shortArrayAppend(StringBuilder sbuf, short[] a10) {
        sbuf.append('[');
        int len = a10.length;
        for (int i10 = 0; i10 < len; ++i10) {
            sbuf.append(a10[i10]);
            if (i10 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void intArrayAppend(StringBuilder sbuf, int[] a10) {
        sbuf.append('[');
        int len = a10.length;
        for (int i10 = 0; i10 < len; ++i10) {
            sbuf.append(a10[i10]);
            if (i10 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void longArrayAppend(StringBuilder sbuf, long[] a10) {
        sbuf.append('[');
        int len = a10.length;
        for (int i10 = 0; i10 < len; ++i10) {
            sbuf.append(a10[i10]);
            if (i10 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void floatArrayAppend(StringBuilder sbuf, float[] a10) {
        sbuf.append('[');
        int len = a10.length;
        for (int i10 = 0; i10 < len; ++i10) {
            sbuf.append(a10[i10]);
            if (i10 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void doubleArrayAppend(StringBuilder sbuf, double[] a10) {
        sbuf.append('[');
        int len = a10.length;
        for (int i10 = 0; i10 < len; ++i10) {
            sbuf.append(a10[i10]);
            if (i10 == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }
}

