/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.format;

import java.text.DateFormatSymbols;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.threeten.bp.format.DateTimeTextProvider;
import org.threeten.bp.format.TextStyle;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.IsoFields;
import org.threeten.bp.temporal.TemporalField;

final class SimpleDateTimeTextProvider
extends DateTimeTextProvider {
    private static final Comparator<Map.Entry<String, Long>> COMPARATOR = new Comparator<Map.Entry<String, Long>>(){

        @Override
        public int compare(Map.Entry<String, Long> obj1, Map.Entry<String, Long> obj2) {
            return obj2.getKey().length() - obj1.getKey().length();
        }
    };
    private final ConcurrentMap<Map.Entry<TemporalField, Locale>, Object> cache = new ConcurrentHashMap<Map.Entry<TemporalField, Locale>, Object>(16, 0.75f, 2);

    SimpleDateTimeTextProvider() {
    }

    @Override
    public String getText(TemporalField field, long value, TextStyle style, Locale locale) {
        Object store = this.findStore(field, locale);
        if (store instanceof LocaleStore) {
            return ((LocaleStore)store).getText(value, style);
        }
        return null;
    }

    @Override
    public Iterator<Map.Entry<String, Long>> getTextIterator(TemporalField field, TextStyle style, Locale locale) {
        Object store = this.findStore(field, locale);
        if (store instanceof LocaleStore) {
            return ((LocaleStore)store).getTextIterator(style);
        }
        return null;
    }

    private Object findStore(TemporalField field, Locale locale) {
        Map.Entry<TemporalField, Locale> key = SimpleDateTimeTextProvider.createEntry(field, locale);
        Object store = this.cache.get(key);
        if (store == null) {
            store = this.createStore(field, locale);
            this.cache.putIfAbsent(key, store);
            store = this.cache.get(key);
        }
        return store;
    }

    private Object createStore(TemporalField field, Locale locale) {
        if (field == ChronoField.MONTH_OF_YEAR) {
            DateFormatSymbols oldSymbols = DateFormatSymbols.getInstance(locale);
            HashMap<TextStyle, Map<Long, String>> styleMap = new HashMap<TextStyle, Map<Long, String>>();
            Long f12 = 1L;
            Long f22 = 2L;
            Long f32 = 3L;
            Long f42 = 4L;
            Long f52 = 5L;
            Long f62 = 6L;
            Long f72 = 7L;
            Long f82 = 8L;
            Long f92 = 9L;
            Long f10 = 10L;
            Long f11 = 11L;
            Long f122 = 12L;
            String[] array = oldSymbols.getMonths();
            HashMap<Long, String> map = new HashMap<Long, String>();
            map.put(f12, array[0]);
            map.put(f22, array[1]);
            map.put(f32, array[2]);
            map.put(f42, array[3]);
            map.put(f52, array[4]);
            map.put(f62, array[5]);
            map.put(f72, array[6]);
            map.put(f82, array[7]);
            map.put(f92, array[8]);
            map.put(f10, array[9]);
            map.put(f11, array[10]);
            map.put(f122, array[11]);
            styleMap.put(TextStyle.FULL, map);
            map = new HashMap();
            map.put(f12, array[0].substring(0, 1));
            map.put(f22, array[1].substring(0, 1));
            map.put(f32, array[2].substring(0, 1));
            map.put(f42, array[3].substring(0, 1));
            map.put(f52, array[4].substring(0, 1));
            map.put(f62, array[5].substring(0, 1));
            map.put(f72, array[6].substring(0, 1));
            map.put(f82, array[7].substring(0, 1));
            map.put(f92, array[8].substring(0, 1));
            map.put(f10, array[9].substring(0, 1));
            map.put(f11, array[10].substring(0, 1));
            map.put(f122, array[11].substring(0, 1));
            styleMap.put(TextStyle.NARROW, map);
            array = oldSymbols.getShortMonths();
            map = new HashMap();
            map.put(f12, array[0]);
            map.put(f22, array[1]);
            map.put(f32, array[2]);
            map.put(f42, array[3]);
            map.put(f52, array[4]);
            map.put(f62, array[5]);
            map.put(f72, array[6]);
            map.put(f82, array[7]);
            map.put(f92, array[8]);
            map.put(f10, array[9]);
            map.put(f11, array[10]);
            map.put(f122, array[11]);
            styleMap.put(TextStyle.SHORT, map);
            return SimpleDateTimeTextProvider.createLocaleStore(styleMap);
        }
        if (field == ChronoField.DAY_OF_WEEK) {
            DateFormatSymbols oldSymbols = DateFormatSymbols.getInstance(locale);
            HashMap<TextStyle, Map<Long, String>> styleMap = new HashMap<TextStyle, Map<Long, String>>();
            Long f13 = 1L;
            Long f23 = 2L;
            Long f33 = 3L;
            Long f43 = 4L;
            Long f53 = 5L;
            Long f63 = 6L;
            Long f73 = 7L;
            String[] array = oldSymbols.getWeekdays();
            HashMap<Long, String> map = new HashMap<Long, String>();
            map.put(f13, array[2]);
            map.put(f23, array[3]);
            map.put(f33, array[4]);
            map.put(f43, array[5]);
            map.put(f53, array[6]);
            map.put(f63, array[7]);
            map.put(f73, array[1]);
            styleMap.put(TextStyle.FULL, map);
            map = new HashMap();
            map.put(f13, array[2].substring(0, 1));
            map.put(f23, array[3].substring(0, 1));
            map.put(f33, array[4].substring(0, 1));
            map.put(f43, array[5].substring(0, 1));
            map.put(f53, array[6].substring(0, 1));
            map.put(f63, array[7].substring(0, 1));
            map.put(f73, array[1].substring(0, 1));
            styleMap.put(TextStyle.NARROW, map);
            array = oldSymbols.getShortWeekdays();
            map = new HashMap();
            map.put(f13, array[2]);
            map.put(f23, array[3]);
            map.put(f33, array[4]);
            map.put(f43, array[5]);
            map.put(f53, array[6]);
            map.put(f63, array[7]);
            map.put(f73, array[1]);
            styleMap.put(TextStyle.SHORT, map);
            return SimpleDateTimeTextProvider.createLocaleStore(styleMap);
        }
        if (field == ChronoField.AMPM_OF_DAY) {
            DateFormatSymbols oldSymbols = DateFormatSymbols.getInstance(locale);
            HashMap<TextStyle, Map<Long, String>> styleMap = new HashMap<TextStyle, Map<Long, String>>();
            String[] array = oldSymbols.getAmPmStrings();
            HashMap<Long, String> map = new HashMap<Long, String>();
            map.put(0L, array[0]);
            map.put(1L, array[1]);
            styleMap.put(TextStyle.FULL, map);
            styleMap.put(TextStyle.SHORT, map);
            return SimpleDateTimeTextProvider.createLocaleStore(styleMap);
        }
        if (field == ChronoField.ERA) {
            DateFormatSymbols oldSymbols = DateFormatSymbols.getInstance(locale);
            HashMap<TextStyle, Map<Long, String>> styleMap = new HashMap<TextStyle, Map<Long, String>>();
            String[] array = oldSymbols.getEras();
            HashMap<Long, String> map = new HashMap<Long, String>();
            map.put(0L, array[0]);
            map.put(1L, array[1]);
            styleMap.put(TextStyle.SHORT, map);
            if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
                map = new HashMap();
                map.put(0L, "Before Christ");
                map.put(1L, "Anno Domini");
                styleMap.put(TextStyle.FULL, map);
            } else {
                styleMap.put(TextStyle.FULL, map);
            }
            map = new HashMap();
            map.put(0L, array[0].substring(0, 1));
            map.put(1L, array[1].substring(0, 1));
            styleMap.put(TextStyle.NARROW, map);
            return SimpleDateTimeTextProvider.createLocaleStore(styleMap);
        }
        if (field == IsoFields.QUARTER_OF_YEAR) {
            HashMap<TextStyle, Map<Long, String>> styleMap = new HashMap<TextStyle, Map<Long, String>>();
            HashMap<Long, String> map = new HashMap<Long, String>();
            map.put(1L, "Q1");
            map.put(2L, "Q2");
            map.put(3L, "Q3");
            map.put(4L, "Q4");
            styleMap.put(TextStyle.SHORT, map);
            map = new HashMap();
            map.put(1L, "1st quarter");
            map.put(2L, "2nd quarter");
            map.put(3L, "3rd quarter");
            map.put(4L, "4th quarter");
            styleMap.put(TextStyle.FULL, map);
            return SimpleDateTimeTextProvider.createLocaleStore(styleMap);
        }
        return "";
    }

    private static <A, B> Map.Entry<A, B> createEntry(A text, B field) {
        return new AbstractMap.SimpleImmutableEntry<A, B>(text, field);
    }

    private static LocaleStore createLocaleStore(Map<TextStyle, Map<Long, String>> valueTextMap) {
        valueTextMap.put(TextStyle.FULL_STANDALONE, valueTextMap.get((Object)TextStyle.FULL));
        valueTextMap.put(TextStyle.SHORT_STANDALONE, valueTextMap.get((Object)TextStyle.SHORT));
        if (valueTextMap.containsKey((Object)TextStyle.NARROW) && !valueTextMap.containsKey((Object)TextStyle.NARROW_STANDALONE)) {
            valueTextMap.put(TextStyle.NARROW_STANDALONE, valueTextMap.get((Object)TextStyle.NARROW));
        }
        return new LocaleStore(valueTextMap);
    }

    static final class LocaleStore {
        private final Map<TextStyle, Map<Long, String>> valueTextMap;
        private final Map<TextStyle, List<Map.Entry<String, Long>>> parsable;

        LocaleStore(Map<TextStyle, Map<Long, String>> valueTextMap) {
            this.valueTextMap = valueTextMap;
            HashMap<TextStyle, List<Map.Entry<String, Long>>> map = new HashMap<TextStyle, List<Map.Entry<String, Long>>>();
            ArrayList allList = new ArrayList();
            for (TextStyle style : valueTextMap.keySet()) {
                HashMap<String, Map.Entry> reverse = new HashMap<String, Map.Entry>();
                for (Map.Entry<Long, String> entry : valueTextMap.get((Object)style).entrySet()) {
                    if (reverse.put(entry.getValue(), SimpleDateTimeTextProvider.createEntry(entry.getValue(), entry.getKey())) == null) continue;
                }
                ArrayList list = new ArrayList(reverse.values());
                Collections.sort(list, COMPARATOR);
                map.put(style, list);
                allList.addAll(list);
                map.put(null, allList);
            }
            Collections.sort(allList, COMPARATOR);
            this.parsable = map;
        }

        String getText(long value, TextStyle style) {
            Map<Long, String> map = this.valueTextMap.get((Object)style);
            return map != null ? map.get(value) : null;
        }

        Iterator<Map.Entry<String, Long>> getTextIterator(TextStyle style) {
            List<Map.Entry<String, Long>> list = this.parsable.get((Object)style);
            return list != null ? list.iterator() : null;
        }
    }
}

