/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.jdk8;

public final class Jdk8Methods {
    private Jdk8Methods() {
    }

    public static <T> T requireNonNull(T value) {
        if (value == null) {
            throw new NullPointerException("Value must not be null");
        }
        return value;
    }

    public static <T> T requireNonNull(T value, String parameterName) {
        if (value == null) {
            throw new NullPointerException(parameterName + " must not be null");
        }
        return value;
    }

    public static boolean equals(Object a10, Object b10) {
        if (a10 == null) {
            return b10 == null;
        }
        if (b10 == null) {
            return false;
        }
        return a10.equals(b10);
    }

    public static int compareInts(int a10, int b10) {
        if (a10 < b10) {
            return -1;
        }
        if (a10 > b10) {
            return 1;
        }
        return 0;
    }

    public static int compareLongs(long a10, long b10) {
        if (a10 < b10) {
            return -1;
        }
        if (a10 > b10) {
            return 1;
        }
        return 0;
    }

    public static int safeAdd(int a10, int b10) {
        int sum = a10 + b10;
        if ((a10 ^ sum) < 0 && (a10 ^ b10) >= 0) {
            throw new ArithmeticException("Addition overflows an int: " + a10 + " + " + b10);
        }
        return sum;
    }

    public static long safeAdd(long a10, long b10) {
        long sum = a10 + b10;
        if ((a10 ^ sum) < 0L && (a10 ^ b10) >= 0L) {
            throw new ArithmeticException("Addition overflows a long: " + a10 + " + " + b10);
        }
        return sum;
    }

    public static int safeSubtract(int a10, int b10) {
        int result = a10 - b10;
        if ((a10 ^ result) < 0 && (a10 ^ b10) < 0) {
            throw new ArithmeticException("Subtraction overflows an int: " + a10 + " - " + b10);
        }
        return result;
    }

    public static long safeSubtract(long a10, long b10) {
        long result = a10 - b10;
        if ((a10 ^ result) < 0L && (a10 ^ b10) < 0L) {
            throw new ArithmeticException("Subtraction overflows a long: " + a10 + " - " + b10);
        }
        return result;
    }

    public static int safeMultiply(int a10, int b10) {
        long total = (long)a10 * (long)b10;
        if (total < Integer.MIN_VALUE || total > Integer.MAX_VALUE) {
            throw new ArithmeticException("Multiplication overflows an int: " + a10 + " * " + b10);
        }
        return (int)total;
    }

    public static long safeMultiply(long a10, int b10) {
        switch (b10) {
            case -1: {
                if (a10 == Long.MIN_VALUE) {
                    throw new ArithmeticException("Multiplication overflows a long: " + a10 + " * " + b10);
                }
                return -a10;
            }
            case 0: {
                return 0L;
            }
            case 1: {
                return a10;
            }
        }
        long total = a10 * (long)b10;
        if (total / (long)b10 != a10) {
            throw new ArithmeticException("Multiplication overflows a long: " + a10 + " * " + b10);
        }
        return total;
    }

    public static long safeMultiply(long a10, long b10) {
        if (b10 == 1L) {
            return a10;
        }
        if (a10 == 1L) {
            return b10;
        }
        if (a10 == 0L || b10 == 0L) {
            return 0L;
        }
        long total = a10 * b10;
        if (total / b10 != a10 || a10 == Long.MIN_VALUE && b10 == -1L || b10 == Long.MIN_VALUE && a10 == -1L) {
            throw new ArithmeticException("Multiplication overflows a long: " + a10 + " * " + b10);
        }
        return total;
    }

    public static int safeToInt(long value) {
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new ArithmeticException("Calculation overflows an int: " + value);
        }
        return (int)value;
    }

    public static long floorDiv(long a10, long b10) {
        return a10 >= 0L ? a10 / b10 : (a10 + 1L) / b10 - 1L;
    }

    public static long floorMod(long a10, long b10) {
        return (a10 % b10 + b10) % b10;
    }

    public static int floorMod(long a10, int b10) {
        return (int)((a10 % (long)b10 + (long)b10) % (long)b10);
    }

    public static int floorDiv(int a10, int b10) {
        return a10 >= 0 ? a10 / b10 : (a10 + 1) / b10 - 1;
    }

    public static int floorMod(int a10, int b10) {
        return (a10 % b10 + b10) % b10;
    }
}

