/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.NetworkIF;
import oshi.hardware.Networks;

public abstract class AbstractNetworks
implements Networks {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNetworks.class);

    @Override
    public NetworkIF[] getNetworks() {
        ArrayList<NetworkIF> result = new ArrayList<NetworkIF>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(interfaces)) {
                if (netint.isLoopback() || netint.getHardwareAddress() == null) continue;
                NetworkIF netIF = new NetworkIF();
                netIF.setNetworkInterface(netint);
                netIF.updateNetworkStats();
                result.add(netIF);
            }
        }
        catch (SocketException ex2) {
            LOG.error("Socket exception when retrieving network interfaces: {}", ex2);
        }
        return result.toArray(new NetworkIF[result.size()]);
    }
}

