/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oshi.hardware.Sensors;
import oshi.util.FileUtil;

public class LinuxSensors
implements Sensors {
    private static final long serialVersionUID = 1L;
    private static final String TEMP = "temp";
    private static final String FAN = "fan";
    private static final String VOLTAGE = "in";
    private static final String[] SENSORS = new String[]{"temp", "fan", "in"};
    private static final String HWMON = "/sys/class/hwmon/hwmon";
    private static final String THERMAL_ZONE = "/sys/class/thermal/thermal_zone";
    private Map<String, String> sensorsMap = new HashMap<String, String>();

    public LinuxSensors() {
        String[] stringArray = SENSORS;
        int n10 = stringArray.length;
        for (int i10 = 0; i10 < n10; ++i10) {
            String sensor;
            final String sensorPrefix = sensor = stringArray[i10];
            this.getSensorFilesFromPath(HWMON, sensor, new FileFilter(){

                @Override
                public boolean accept(File f10) {
                    return f10.getName().startsWith(sensorPrefix) && f10.getName().endsWith("_input");
                }
            });
        }
        if (!this.sensorsMap.containsKey(TEMP)) {
            this.getSensorFilesFromPath(THERMAL_ZONE, TEMP, new FileFilter(){

                @Override
                public boolean accept(File f10) {
                    return f10.getName().equals(LinuxSensors.TEMP);
                }
            });
        }
    }

    private void getSensorFilesFromPath(String sensorPath, String sensor, FileFilter sensorFileFilter) {
        int i10 = 0;
        while (Paths.get(sensorPath + i10, new String[0]).toFile().isDirectory()) {
            String path = sensorPath + i10;
            File dir = new File(path);
            File[] matchingFiles = dir.listFiles(sensorFileFilter);
            if (matchingFiles != null && matchingFiles.length > 0) {
                this.sensorsMap.put(sensor, String.format("%s/%s", path, sensor));
            }
            ++i10;
        }
    }

    @Override
    public double getCpuTemperature() {
        if (!this.sensorsMap.containsKey(TEMP)) {
            return 0.0;
        }
        String hwmon = this.sensorsMap.get(TEMP);
        long millidegrees = FileUtil.getLongFromFile(String.format("%s1_input", hwmon));
        if (millidegrees > 0L) {
            return (double)millidegrees / 1000.0;
        }
        int sum = 0;
        int count = 0;
        for (int i10 = 2; i10 <= 6; ++i10) {
            millidegrees = FileUtil.getLongFromFile(String.format("%s%d_input", hwmon, i10));
            if (millidegrees <= 0L) continue;
            sum = (int)((long)sum + millidegrees);
            ++count;
        }
        if (count > 0) {
            return (double)sum / ((double)count * 1000.0);
        }
        millidegrees = FileUtil.getLongFromFile(String.format("%s", hwmon));
        if (millidegrees > 0L) {
            return (double)millidegrees / 1000.0;
        }
        return 0.0;
    }

    @Override
    public int[] getFanSpeeds() {
        if (this.sensorsMap.containsKey(FAN)) {
            String fanPath;
            String hwmon = this.sensorsMap.get(FAN);
            ArrayList<Integer> speeds = new ArrayList<Integer>();
            int fan = 1;
            while (new File(fanPath = String.format("%s%d_input", hwmon, fan)).exists()) {
                speeds.add(FileUtil.getIntFromFile(fanPath));
                ++fan;
            }
            int[] fanSpeeds = new int[speeds.size()];
            for (int i10 = 0; i10 < speeds.size(); ++i10) {
                fanSpeeds[i10] = (Integer)speeds.get(i10);
            }
            return fanSpeeds;
        }
        return new int[0];
    }

    @Override
    public double getCpuVoltage() {
        if (this.sensorsMap.containsKey(VOLTAGE)) {
            String hwmon = this.sensorsMap.get(VOLTAGE);
            return (double)FileUtil.getIntFromFile(String.format("%s1_input", hwmon)) / 1000.0;
        }
        return 0.0;
    }
}

