/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Native;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.hardware.platform.mac.MacComputerSystem;
import oshi.jna.platform.mac.SystemB;
import oshi.jna.platform.unix.CLibrary;
import oshi.util.ExecutingCommand;
import oshi.util.FormatUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.mac.SysctlUtil;

public class MacCentralProcessor
extends AbstractCentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MacCentralProcessor.class);
    private static final long BOOTTIME;

    public MacCentralProcessor() {
        this.initVars();
        this.initTicks();
        LOG.debug("Initialized Processor");
    }

    private void initVars() {
        this.setVendor(SysctlUtil.sysctl("machdep.cpu.vendor", ""));
        this.setName(SysctlUtil.sysctl("machdep.cpu.brand_string", ""));
        this.setCpu64(SysctlUtil.sysctl("hw.cpu64bit_capable", 0) != 0);
        int i10 = SysctlUtil.sysctl("machdep.cpu.stepping", -1);
        this.setStepping(i10 < 0 ? "" : Integer.toString(i10));
        i10 = SysctlUtil.sysctl("machdep.cpu.model", -1);
        this.setModel(i10 < 0 ? "" : Integer.toString(i10));
        i10 = SysctlUtil.sysctl("machdep.cpu.family", -1);
        this.setFamily(i10 < 0 ? "" : Integer.toString(i10));
        long processorID = 0L;
        processorID |= (long)SysctlUtil.sysctl("machdep.cpu.signature", 0);
        this.setProcessorID(String.format("%016X", processorID |= (SysctlUtil.sysctl("machdep.cpu.feature_bits", 0L) & 0xFFFFFFFFFFFFFFFFL) << 32));
    }

    @Override
    protected void calculateProcessorCounts() {
        this.logicalProcessorCount = SysctlUtil.sysctl("hw.logicalcpu", 1);
        this.physicalProcessorCount = SysctlUtil.sysctl("hw.physicalcpu", 1);
        this.physicalPackageCount = SysctlUtil.sysctl("hw.packages", 1);
    }

    @Override
    public long[] getSystemCpuLoadTicks() {
        SystemB.HostCpuLoadInfo cpuLoadInfo;
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        int machPort = SystemB.INSTANCE.mach_host_self();
        if (0 != SystemB.INSTANCE.host_statistics(machPort, 3, cpuLoadInfo = new SystemB.HostCpuLoadInfo(), new IntByReference(cpuLoadInfo.size()))) {
            LOG.error("Failed to get System CPU ticks. Error code: {} ", (Object)Native.getLastError());
            return ticks;
        }
        ticks[CentralProcessor.TickType.USER.getIndex()] = cpuLoadInfo.cpu_ticks[0];
        ticks[CentralProcessor.TickType.NICE.getIndex()] = cpuLoadInfo.cpu_ticks[3];
        ticks[CentralProcessor.TickType.SYSTEM.getIndex()] = cpuLoadInfo.cpu_ticks[1];
        ticks[CentralProcessor.TickType.IDLE.getIndex()] = cpuLoadInfo.cpu_ticks[2];
        return ticks;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = SystemB.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            for (int i10 = Math.max(retval, 0); i10 < average.length; ++i10) {
                average[i10] = -1.0;
            }
        }
        return average;
    }

    @Override
    public long[][] getProcessorCpuLoadTicks() {
        IntByReference procInfoCount;
        PointerByReference procCpuLoadInfo;
        IntByReference procCount;
        long[][] ticks = new long[this.logicalProcessorCount][CentralProcessor.TickType.values().length];
        int machPort = SystemB.INSTANCE.mach_host_self();
        if (0 != SystemB.INSTANCE.host_processor_info(machPort, 2, procCount = new IntByReference(), procCpuLoadInfo = new PointerByReference(), procInfoCount = new IntByReference())) {
            LOG.error("Failed to update CPU Load. Error code: {}", (Object)Native.getLastError());
            return ticks;
        }
        int[] cpuTicks = procCpuLoadInfo.getValue().getIntArray(0L, procInfoCount.getValue());
        for (int cpu = 0; cpu < procCount.getValue(); ++cpu) {
            int offset = cpu * 4;
            ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = FormatUtil.getUnsignedInt(cpuTicks[offset + 0]);
            ticks[cpu][CentralProcessor.TickType.NICE.getIndex()] = FormatUtil.getUnsignedInt(cpuTicks[offset + 3]);
            ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = FormatUtil.getUnsignedInt(cpuTicks[offset + 1]);
            ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = FormatUtil.getUnsignedInt(cpuTicks[offset + 2]);
        }
        return ticks;
    }

    @Override
    public long getSystemUptime() {
        return System.currentTimeMillis() / 1000L - BOOTTIME;
    }

    @Override
    @Deprecated
    public String getSystemSerialNumber() {
        return new MacComputerSystem().getSerialNumber();
    }

    @Override
    public long getContextSwitches() {
        SystemB.VMMeter vmstats;
        int machPort = SystemB.INSTANCE.mach_host_self();
        if (0 != SystemB.INSTANCE.host_statistics(machPort, 2, vmstats = new SystemB.VMMeter(), new IntByReference(vmstats.size()))) {
            LOG.error("Failed to update vmstats. Error code: {}", (Object)Native.getLastError());
            return -1L;
        }
        return ParseUtil.unsignedIntToLong(vmstats.v_swtch);
    }

    @Override
    public long getInterrupts() {
        SystemB.VMMeter vmstats;
        int machPort = SystemB.INSTANCE.mach_host_self();
        if (0 != SystemB.INSTANCE.host_statistics(machPort, 2, vmstats = new SystemB.VMMeter(), new IntByReference(vmstats.size()))) {
            LOG.error("Failed to update vmstats. Error code: {}", (Object)Native.getLastError());
            return -1L;
        }
        return ParseUtil.unsignedIntToLong(vmstats.v_intr);
    }

    static {
        CLibrary.Timeval tv2 = new CLibrary.Timeval();
        BOOTTIME = !SysctlUtil.sysctl("kern.boottime", tv2) || tv2.tv_sec == 0L ? ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("sysctl -n kern.boottime").split(",")[0].replaceAll("\\D", ""), System.currentTimeMillis() / 1000L) : tv2.tv_sec;
    }
}

