/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.Display;
import oshi.hardware.common.AbstractDisplay;
import oshi.jna.platform.mac.CoreFoundation;
import oshi.jna.platform.mac.IOKit;
import oshi.util.platform.mac.CfUtil;
import oshi.util.platform.mac.IOKitUtil;

public class MacDisplay
extends AbstractDisplay {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MacDisplay.class);
    private static final CoreFoundation.CFStringRef cfEdid = CoreFoundation.CFStringRef.toCFString("IODisplayEDID");

    public MacDisplay(byte[] edid) {
        super(edid);
        LOG.debug("Initialized MacDisplay");
    }

    public static Display[] getDisplays() {
        ArrayList<MacDisplay> displays = new ArrayList<MacDisplay>();
        IntByReference serviceIterator = new IntByReference();
        IOKitUtil.getMatchingServices("IODisplayConnect", serviceIterator);
        int sdService = IOKit.INSTANCE.IOIteratorNext(serviceIterator.getValue());
        while (sdService != 0) {
            CoreFoundation.CFTypeRef edid;
            IntByReference properties = new IntByReference();
            int ret = IOKit.INSTANCE.IORegistryEntryGetChildEntry(sdService, "IOService", properties);
            if (ret == 0 && (edid = IOKit.INSTANCE.IORegistryEntryCreateCFProperty(properties.getValue(), cfEdid, CfUtil.ALLOCATOR, 0)) != null) {
                int length = CoreFoundation.INSTANCE.CFDataGetLength(edid);
                PointerByReference p10 = CoreFoundation.INSTANCE.CFDataGetBytePtr(edid);
                displays.add(new MacDisplay(p10.getPointer().getByteArray(0L, length)));
                CfUtil.release(edid);
            }
            IOKit.INSTANCE.IOObjectRelease(sdService);
            sdService = IOKit.INSTANCE.IOIteratorNext(serviceIterator.getValue());
        }
        IOKit.INSTANCE.IOObjectRelease(serviceIterator.getValue());
        return displays.toArray(new Display[displays.size()]);
    }
}

