/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import oshi.hardware.Sensors;
import oshi.jna.platform.unix.freebsd.Libc;

public class FreeBsdSensors
implements Sensors {
    private static final long serialVersionUID = 1L;

    @Override
    public double getCpuTemperature() {
        double sumTemp = 0.0;
        int cpu = 0;
        String name = "dev.cpu.%d.temperature";
        while (true) {
            IntByReference size = new IntByReference(Libc.INT_SIZE);
            Memory p10 = new Memory(size.getValue());
            if (0 != Libc.INSTANCE.sysctlbyname(String.format(name, cpu), p10, size, null, 0)) break;
            sumTemp += (double)((Pointer)p10).getInt(0L) / 10.0 - 273.15;
            ++cpu;
        }
        if (cpu > 0) {
            return sumTemp / (double)cpu;
        }
        return 0.0;
    }

    @Override
    public int[] getFanSpeeds() {
        return new int[0];
    }

    @Override
    public double getCpuVoltage() {
        return 0.0;
    }
}

