/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.solaris.KstatUtil;

public class SolarisGlobalMemory
extends AbstractGlobalMemory {
    private static final long serialVersionUID = 1L;
    private static final Pattern SWAPINFO = Pattern.compile(".+\\s(\\d+)K\\s+(\\d+)K$");

    public SolarisGlobalMemory() {
        this.pageSize = ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("pagesize"), 4096L);
    }

    @Override
    protected void updateMeminfo() {
        LibKstat.Kstat ksp = KstatUtil.kstatLookup(null, -1, "system_pages");
        if (ksp != null && KstatUtil.kstatRead(ksp)) {
            this.memAvailable = KstatUtil.kstatDataLookupLong(ksp, "availrmem") * this.pageSize;
            this.memTotal = KstatUtil.kstatDataLookupLong(ksp, "physmem") * this.pageSize;
        }
        this.swapPagesIn = 0L;
        List<String> kstat = ExecutingCommand.runNative("kstat -p cpu_stat:::pgpgin");
        for (String s10 : kstat) {
            this.swapPagesIn += ParseUtil.parseLastLong(s10, 0L);
        }
        this.swapPagesOut = 0L;
        kstat = ExecutingCommand.runNative("kstat -p cpu_stat:::pgpgout");
        for (String s10 : kstat) {
            this.swapPagesOut += ParseUtil.parseLastLong(s10, 0L);
        }
    }

    @Override
    protected void updateSwap() {
        String swapInfo = ExecutingCommand.getAnswerAt("swap -lk", 1);
        Matcher m10 = SWAPINFO.matcher(swapInfo);
        if (m10.matches()) {
            this.swapTotal = ParseUtil.parseLongOrDefault(m10.group(1), 0L) << 10;
            this.swapUsed = this.swapTotal - (ParseUtil.parseLongOrDefault(m10.group(2), 0L) << 10);
        }
    }
}

