/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import java.util.List;
import java.util.Map;
import org.threeten.bp.Instant;
import org.threeten.bp.ZoneOffset;
import oshi.hardware.common.AbstractFirmware;
import oshi.util.platform.windows.WmiUtil;

final class WindowsFirmware
extends AbstractFirmware {
    private static final long serialVersionUID = 1L;
    private static final WmiProperty[] BIOS_PROPERTIES;
    private static final String[] BIOS_STRINGS;
    private static final WmiUtil.ValueType[] BIOS_TYPES;

    WindowsFirmware() {
        this.init();
    }

    private void init() {
        List<Object> releaseDate;
        List<Object> version;
        List<Object> descriptions;
        List<Object> names;
        Map<String, List<Object>> win32BIOS = WmiUtil.selectObjectsFrom(null, "Win32_BIOS", BIOS_STRINGS, "where PrimaryBIOS=true", BIOS_TYPES);
        List<Object> manufacturers = win32BIOS.get(WmiProperty.MANUFACTURER.name());
        if (manufacturers != null && manufacturers.size() == 1) {
            this.setManufacturer((String)manufacturers.get(0));
        }
        if ((names = win32BIOS.get(WmiProperty.NAME.name())) != null && names.size() == 1) {
            this.setName((String)names.get(0));
        }
        if ((descriptions = win32BIOS.get(WmiProperty.DESCRIPTION.name())) != null && descriptions.size() == 1) {
            this.setDescription((String)descriptions.get(0));
        }
        if ((version = win32BIOS.get(WmiProperty.VERSION.name())) != null && version.size() == 1) {
            this.setVersion((String)version.get(0));
        }
        if ((releaseDate = win32BIOS.get(WmiProperty.RELEASEDATE.name())) != null && releaseDate.size() == 1) {
            this.setReleaseDate(Instant.ofEpochMilli((Long)releaseDate.get(0)).atZone(ZoneOffset.UTC).toLocalDate());
        }
    }

    static {
        int i10;
        BIOS_PROPERTIES = new WmiProperty[]{WmiProperty.MANUFACTURER, WmiProperty.NAME, WmiProperty.DESCRIPTION, WmiProperty.VERSION, WmiProperty.RELEASEDATE};
        BIOS_STRINGS = new String[BIOS_PROPERTIES.length];
        for (i10 = 0; i10 < BIOS_PROPERTIES.length; ++i10) {
            WindowsFirmware.BIOS_STRINGS[i10] = BIOS_PROPERTIES[i10].name();
        }
        BIOS_TYPES = new WmiUtil.ValueType[BIOS_PROPERTIES.length];
        for (i10 = 0; i10 < BIOS_PROPERTIES.length; ++i10) {
            WindowsFirmware.BIOS_TYPES[i10] = BIOS_PROPERTIES[i10].getType();
        }
    }

    static enum WmiProperty {
        MANUFACTURER(WmiUtil.ValueType.STRING),
        NAME(WmiUtil.ValueType.STRING),
        DESCRIPTION(WmiUtil.ValueType.STRING),
        VERSION(WmiUtil.ValueType.STRING),
        RELEASEDATE(WmiUtil.ValueType.DATETIME);

        private WmiUtil.ValueType type;

        public WmiUtil.ValueType getType() {
            return this.type;
        }

        private WmiProperty(WmiUtil.ValueType type) {
            this.type = type;
        }
    }
}

