/*
 * Decompiled with CFR 0.152.
 */
package oshi.jna.platform.windows;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.WinDef;
import java.util.ArrayList;
import java.util.List;
import oshi.jna.platform.windows.Pdh;

public abstract class PdhUtilJNA {
    public static String PdhLookupPerfNameByIndex(String szMachineName, int dwNameIndex) {
        int charToBytes = Boolean.getBoolean("w32.ascii") ? 1 : Native.WCHAR_SIZE;
        WinDef.DWORDByReference pcchNameBufferSize = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        Pdh.INSTANCE.PdhLookupPerfNameByIndex(null, dwNameIndex, null, pcchNameBufferSize);
        Memory mem = new Memory(pcchNameBufferSize.getValue().intValue() * charToBytes);
        Pdh.INSTANCE.PdhLookupPerfNameByIndex(null, dwNameIndex, mem, pcchNameBufferSize);
        if (charToBytes == 1) {
            return mem.getString(0L);
        }
        return mem.getWideString(0L);
    }

    public static List<String> PdhEnumObjectItemCounters(String szDataSource, String szMachineName, String szObjectName, int dwDetailLevel) {
        int charToBytes = Boolean.getBoolean("w32.ascii") ? 1 : Native.WCHAR_SIZE;
        WinDef.DWORDByReference pcchCounterListLength = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        WinDef.DWORDByReference pcchInstanceListLength = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        Pdh.INSTANCE.PdhEnumObjectItems(szDataSource, szMachineName, szObjectName, null, pcchCounterListLength, null, pcchInstanceListLength, dwDetailLevel, 0);
        Memory mszCounterList = new Memory(pcchCounterListLength.getValue().intValue() * charToBytes);
        Memory mszInstanceList = new Memory(pcchInstanceListLength.getValue().intValue() * charToBytes);
        Pdh.INSTANCE.PdhEnumObjectItems(szDataSource, szMachineName, szObjectName, mszCounterList, pcchCounterListLength, mszInstanceList, pcchInstanceListLength, dwDetailLevel, 0);
        ArrayList<String> counters = new ArrayList<String>();
        int offset = 0;
        while ((long)offset < mszCounterList.size()) {
            String s10 = null;
            s10 = charToBytes == 1 ? mszCounterList.getString(offset) : mszCounterList.getWideString(offset);
            if (s10.isEmpty()) break;
            counters.add(s10);
            offset += (s10.length() + 1) * charToBytes;
        }
        return counters;
    }

    public static List<String> PdhEnumObjectItemInstances(String szDataSource, String szMachineName, String szObjectName, int dwDetailLevel) {
        int charToBytes = Boolean.getBoolean("w32.ascii") ? 1 : Native.WCHAR_SIZE;
        WinDef.DWORDByReference pcchCounterListLength = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        WinDef.DWORDByReference pcchInstanceListLength = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        Pdh.INSTANCE.PdhEnumObjectItems(szDataSource, szMachineName, szObjectName, null, pcchCounterListLength, null, pcchInstanceListLength, dwDetailLevel, 0);
        Memory mszCounterList = new Memory(pcchCounterListLength.getValue().intValue() * charToBytes);
        Memory mszInstanceList = new Memory(pcchInstanceListLength.getValue().intValue() * charToBytes);
        Pdh.INSTANCE.PdhEnumObjectItems(szDataSource, szMachineName, szObjectName, mszCounterList, pcchCounterListLength, mszInstanceList, pcchInstanceListLength, dwDetailLevel, 0);
        ArrayList<String> instances = new ArrayList<String>();
        int offset = 0;
        while ((long)offset < mszInstanceList.size()) {
            String s10 = null;
            s10 = charToBytes == 1 ? mszInstanceList.getString(offset) : mszInstanceList.getWideString(offset);
            if (s10.isEmpty()) break;
            instances.add(s10);
            offset += (s10.length() + 1) * charToBytes;
        }
        return instances;
    }
}

