/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.software.os.NetworkParams;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

public abstract class AbstractNetworkParams
implements NetworkParams {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNetworkParams.class);
    private static final String NAMESERVER = "nameserver";

    @Override
    public String getDomainName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e10) {
            LOG.error("Unknown host exception when getting address of local host: " + e10);
            return "";
        }
    }

    @Override
    public String getHostName() {
        try {
            String hn2 = InetAddress.getLocalHost().getHostName();
            int dot = hn2.indexOf(46);
            if (dot == -1) {
                return hn2;
            }
            return hn2.substring(0, dot);
        }
        catch (UnknownHostException e10) {
            LOG.error("Unknown host exception when getting address of local host: " + e10);
            return "";
        }
    }

    @Override
    public String[] getDnsServers() {
        List<String> resolv = FileUtil.readFile("/etc/resolv.conf");
        String key = NAMESERVER;
        int maxNameServer = 3;
        ArrayList<String> servers = new ArrayList<String>();
        for (int i10 = 0; i10 < resolv.size() && servers.size() < maxNameServer; ++i10) {
            String value;
            String line = resolv.get(i10);
            if (!line.startsWith(key) || (value = line.substring(key.length()).replaceFirst("^[ \t]+", "")).length() == 0 || value.charAt(0) == '#' || value.charAt(0) == ';') continue;
            String val = value.split("[ \t#;]", 2)[0];
            servers.add(val);
        }
        return servers.toArray(new String[servers.size()]);
    }

    protected static String searchGateway(List<String> lines) {
        for (String line : lines) {
            String leftTrimmed = line.replaceFirst("^\\s+", "");
            if (!leftTrimmed.startsWith("gateway:")) continue;
            String[] split = ParseUtil.whitespaces.split(leftTrimmed);
            if (split.length < 2) {
                return "";
            }
            return split[1].split("%")[0];
        }
        return "";
    }
}

