/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.software.os.OperatingSystemVersion;

public abstract class AbstractOperatingSystem
implements OperatingSystem {
    private static final long serialVersionUID = 1L;
    protected String manufacturer;
    protected String family;
    protected OperatingSystemVersion version;
    protected int bitness = System.getProperty("os.arch").indexOf("64") != -1 ? 64 : 32;
    private static final Comparator<OSProcess> CPU_DESC_SORT = new Comparator<OSProcess>(){

        @Override
        public int compare(OSProcess p12, OSProcess p22) {
            return Double.compare((double)(p22.getKernelTime() + p22.getUserTime()) / (double)p22.getUpTime(), (double)(p12.getKernelTime() + p12.getUserTime()) / (double)p12.getUpTime());
        }
    };
    private static final Comparator<OSProcess> RSS_DESC_SORT = new Comparator<OSProcess>(){

        @Override
        public int compare(OSProcess p12, OSProcess p22) {
            return Long.compare(p22.getResidentSetSize(), p12.getResidentSetSize());
        }
    };
    private static final Comparator<OSProcess> UPTIME_DESC_SORT = new Comparator<OSProcess>(){

        @Override
        public int compare(OSProcess p12, OSProcess p22) {
            return Long.compare(p22.getUpTime(), p12.getUpTime());
        }
    };
    private static final Comparator<OSProcess> UPTIME_ASC_SORT = new Comparator<OSProcess>(){

        @Override
        public int compare(OSProcess p12, OSProcess p22) {
            return Long.compare(p12.getUpTime(), p22.getUpTime());
        }
    };
    private static final Comparator<OSProcess> PID_ASC_SORT = new Comparator<OSProcess>(){

        @Override
        public int compare(OSProcess p12, OSProcess p22) {
            return Integer.compare(p12.getProcessID(), p22.getProcessID());
        }
    };
    private static final Comparator<OSProcess> PARENTPID_ASC_SORT = new Comparator<OSProcess>(){

        @Override
        public int compare(OSProcess p12, OSProcess p22) {
            return Integer.compare(p12.getParentProcessID(), p22.getParentProcessID());
        }
    };
    private static final Comparator<OSProcess> NAME_ASC_SORT = new Comparator<OSProcess>(){

        @Override
        public int compare(OSProcess p12, OSProcess p22) {
            return p12.getName().toLowerCase().compareTo(p22.getName().toLowerCase());
        }
    };

    @Override
    public OperatingSystemVersion getVersion() {
        return this.version;
    }

    @Override
    public String getFamily() {
        return this.family;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    protected List<OSProcess> processSort(List<OSProcess> processes, int limit, OperatingSystem.ProcessSort sort) {
        if (sort != null) {
            switch (sort) {
                case CPU: {
                    Collections.sort(processes, CPU_DESC_SORT);
                    break;
                }
                case MEMORY: {
                    Collections.sort(processes, RSS_DESC_SORT);
                    break;
                }
                case OLDEST: {
                    Collections.sort(processes, UPTIME_DESC_SORT);
                    break;
                }
                case NEWEST: {
                    Collections.sort(processes, UPTIME_ASC_SORT);
                    break;
                }
                case PID: {
                    Collections.sort(processes, PID_ASC_SORT);
                    break;
                }
                case PARENTPID: {
                    Collections.sort(processes, PARENTPID_ASC_SORT);
                    break;
                }
                case NAME: {
                    Collections.sort(processes, NAME_ASC_SORT);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unimplemented enum type: " + sort.toString());
                }
            }
        }
        int maxProcs = processes.size();
        if (limit <= 0 || maxProcs <= limit) {
            return processes;
        }
        maxProcs = limit;
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        for (int i10 = 0; i10 < maxProcs; ++i10) {
            procs.add(processes.get(i10));
        }
        return procs;
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append(this.getManufacturer()).append(' ').append(this.getFamily()).append(' ').append(this.getVersion().toString());
        return sb2.toString();
    }

    @Override
    public List<OSProcess> getProcesses(Collection<Integer> pids) {
        LinkedList<OSProcess> returnValue = new LinkedList<OSProcess>();
        for (Integer pid : pids) {
            OSProcess process = this.getProcess(pid);
            if (process == null) continue;
            returnValue.add(process);
        }
        return returnValue;
    }

    @Override
    public int getBitness() {
        return this.bitness;
    }
}

