/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.linux;

import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.software.common.AbstractOSVersionInfoEx;
import oshi.software.os.linux.LinuxOperatingSystem;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

public class LinuxOSVersionInfoEx
extends AbstractOSVersionInfoEx {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LinuxOSVersionInfoEx.class);

    public LinuxOSVersionInfoEx() {
        this(null, null);
    }

    protected LinuxOSVersionInfoEx(String versionId, String codeName) {
        this.setVersion(versionId);
        this.setCodeName(codeName);
        if (this.getVersion() == null) {
            this.setVersionFromReleaseFiles();
        }
        if (this.getCodeName() == null) {
            this.setCodeName("");
        }
        List<String> procVersion = null;
        procVersion = FileUtil.readFile("/proc/version");
        if (!procVersion.isEmpty()) {
            String[] split;
            for (String s10 : split = ParseUtil.whitespaces.split(procVersion.get(0))) {
                if ("Linux".equals(s10) || "version".equals(s10)) continue;
                this.setBuildNumber(s10);
                return;
            }
        }
        this.setBuildNumber("");
    }

    private void setVersionFromReleaseFiles() {
        if (this.readOsRelease()) {
            return;
        }
        if (this.execLsbRelease()) {
            return;
        }
        if (this.readLsbRelease()) {
            return;
        }
        String etcDistribRelease = LinuxOperatingSystem.getReleaseFilename();
        if (this.readDistribRelease(etcDistribRelease)) {
            return;
        }
        if (this.getVersion() == null) {
            this.setVersion(System.getProperty("os.version"));
        }
    }

    private boolean readOsRelease() {
        if (new File("/etc/os-release").exists()) {
            List<String> osRelease = FileUtil.readFile("/etc/os-release");
            for (String line : osRelease) {
                if (line.startsWith("VERSION=")) {
                    LOG.debug("os-release: {}", (Object)line);
                    line = line.replace("VERSION=", "").replaceAll("^\"|\"$", "").trim();
                    String[] split = line.split("[()]");
                    if (split.length <= 1) {
                        split = line.split(", ");
                    }
                    if (split.length > 0) {
                        this.version = split[0].trim();
                    }
                    if (split.length <= 1) continue;
                    this.codeName = split[1].trim();
                    continue;
                }
                if (!line.startsWith("VERSION_ID=") || this.version != null) continue;
                LOG.debug("os-release: {}", (Object)line);
                this.version = line.replace("VERSION_ID=", "").replaceAll("^\"|\"$", "").trim();
            }
        }
        return this.version != null;
    }

    private boolean execLsbRelease() {
        for (String line : ExecutingCommand.runNative("lsb_release -a")) {
            if (line.startsWith("Description:")) {
                LOG.debug("lsb_release -a: {}", (Object)line);
                if (!(line = line.replace("Description:", "").trim()).contains(" release ")) continue;
                this.version = this.parseRelease(line, " release ");
                continue;
            }
            if (line.startsWith("Release:") && this.version == null) {
                LOG.debug("lsb_release -a: {}", (Object)line);
                this.version = line.replace("Release:", "").trim();
                continue;
            }
            if (!line.startsWith("Codename:") || this.codeName != null) continue;
            LOG.debug("lsb_release -a: {}", (Object)line);
            this.codeName = line.replace("Codename:", "").trim();
        }
        return this.version != null;
    }

    private boolean readLsbRelease() {
        if (new File("/etc/lsb-release").exists()) {
            List<String> osRelease = FileUtil.readFile("/etc/lsb-release");
            for (String line : osRelease) {
                if (line.startsWith("DISTRIB_DESCRIPTION=")) {
                    LOG.debug("lsb-release: {}", (Object)line);
                    if (!(line = line.replace("DISTRIB_DESCRIPTION=", "").replaceAll("^\"|\"$", "").trim()).contains(" release ")) continue;
                    this.version = this.parseRelease(line, " release ");
                    continue;
                }
                if (line.startsWith("DISTRIB_RELEASE=") && this.version == null) {
                    LOG.debug("lsb-release: {}", (Object)line);
                    this.version = line.replace("DISTRIB_RELEASE=", "").replaceAll("^\"|\"$", "").trim();
                    continue;
                }
                if (!line.startsWith("DISTRIB_CODENAME=") || this.codeName != null) continue;
                LOG.debug("lsb-release: {}", (Object)line);
                this.codeName = line.replace("DISTRIB_CODENAME=", "").replaceAll("^\"|\"$", "").trim();
            }
        }
        return this.version != null;
    }

    private boolean readDistribRelease(String filename) {
        if (new File(filename).exists()) {
            List<String> osRelease = FileUtil.readFile(filename);
            for (String line : osRelease) {
                LOG.debug("{}: {}", (Object)filename, (Object)line);
                if (line.contains(" release ")) {
                    this.version = this.parseRelease(line, " release ");
                    break;
                }
                if (!line.contains(" VERSION ")) continue;
                this.version = this.parseRelease(line, " VERSION ");
                break;
            }
        }
        return this.version != null;
    }

    private String parseRelease(String line, String splitLine) {
        String[] split = line.split(splitLine);
        if (split.length > 1) {
            if ((split = split[1].split("[()]")).length > 0) {
                this.version = split[0].trim();
            }
            if (split.length > 1) {
                this.codeName = split[1].trim();
            }
        }
        return this.version;
    }
}

