/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.jna.platform.mac.CoreFoundation;
import oshi.jna.platform.mac.DiskArbitration;
import oshi.jna.platform.mac.IOKit;
import oshi.jna.platform.mac.SystemB;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.util.platform.mac.CfUtil;
import oshi.util.platform.mac.IOKitUtil;
import oshi.util.platform.mac.SysctlUtil;

public class MacFileSystem
implements FileSystem {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MacFileSystem.class);
    private static final Pattern LOCAL_DISK = Pattern.compile("/dev/disk\\d");

    @Override
    public OSFileStore[] getFileStores() {
        DiskArbitration.DASessionRef session = DiskArbitration.INSTANCE.DASessionCreate(CfUtil.ALLOCATOR);
        if (session == null) {
            LOG.error("Unable to open session to DiskArbitration framework.");
        }
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        int numfs = SystemB.INSTANCE.getfsstat64((SystemB.Statfs[])null, 0, 0);
        if (numfs > 0) {
            SystemB.Statfs[] fs2 = new SystemB.Statfs[numfs];
            numfs = SystemB.INSTANCE.getfsstat64(fs2, numfs * new SystemB.Statfs().size(), 16);
            for (int f10 = 0; f10 < numfs; ++f10) {
                String volume = new String(fs2[f10].f_mntfromname).trim();
                if (volume.equals("devfs") || volume.startsWith("map ")) continue;
                String description = "Volume";
                if (LOCAL_DISK.matcher(volume).matches()) {
                    description = "Local Disk";
                }
                if (volume.startsWith("localhost:") || volume.startsWith("//")) {
                    description = "Network Drive";
                }
                String type = new String(fs2[f10].f_fstypename).trim();
                String path = new String(fs2[f10].f_mntonname).trim();
                String name = "";
                String uuid = "";
                String bsdName = volume.replace("/dev/disk", "disk");
                if (bsdName.startsWith("disk")) {
                    CoreFoundation.CFMutableDictionaryRef matchingDict;
                    DiskArbitration.DADiskRef disk = DiskArbitration.INSTANCE.DADiskCreateFromBSDName(CfUtil.ALLOCATOR, session, volume);
                    if (disk != null) {
                        CoreFoundation.CFDictionaryRef diskInfo = DiskArbitration.INSTANCE.DADiskCopyDescription(disk);
                        if (diskInfo != null) {
                            Pointer volumePtr = CoreFoundation.INSTANCE.CFDictionaryGetValue(diskInfo, CfUtil.getCFString("DAVolumeName"));
                            name = CfUtil.cfPointerToString(volumePtr);
                            CfUtil.release(diskInfo);
                        }
                        CfUtil.release(disk);
                    }
                    if ((matchingDict = IOKitUtil.getBSDNameMatchingDict(bsdName)) != null) {
                        IntByReference fsIter = new IntByReference();
                        IOKitUtil.getMatchingServices(matchingDict, fsIter);
                        int fsEntry = IOKit.INSTANCE.IOIteratorNext(fsIter.getValue());
                        if (fsEntry != 0 && IOKit.INSTANCE.IOObjectConformsTo(fsEntry, "IOMedia")) {
                            uuid = IOKitUtil.getIORegistryStringProperty(fsEntry, "UUID");
                            uuid = uuid == null ? "" : uuid.toLowerCase();
                            IOKit.INSTANCE.IOObjectRelease(fsEntry);
                        }
                        IOKit.INSTANCE.IOObjectRelease(fsIter.getValue());
                    }
                }
                File file = new File(path);
                if (name.isEmpty() && (name = file.getName()).isEmpty()) {
                    name = file.getPath();
                }
                fsList.add(new OSFileStore(name, volume, path, description, type, uuid, file.getUsableSpace(), file.getTotalSpace()));
            }
        }
        CfUtil.release(session);
        return fsList.toArray(new OSFileStore[fsList.size()]);
    }

    @Override
    public long getOpenFileDescriptors() {
        return SysctlUtil.sysctl("kern.num_files", 0);
    }

    @Override
    public long getMaxFileDescriptors() {
        return SysctlUtil.sysctl("kern.maxfiles", 0);
    }
}

