/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsOSSystemInfo {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsOSSystemInfo.class);
    private WinBase.SYSTEM_INFO _si = null;

    public WindowsOSSystemInfo() {
        WinBase.SYSTEM_INFO si2 = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetSystemInfo(si2);
        try {
            IntByReference isWow64 = new IntByReference();
            WinNT.HANDLE hProcess = Kernel32.INSTANCE.GetCurrentProcess();
            if (Kernel32.INSTANCE.IsWow64Process(hProcess, isWow64) && isWow64.getValue() > 0) {
                Kernel32.INSTANCE.GetNativeSystemInfo(si2);
            }
        }
        catch (UnsatisfiedLinkError e10) {
            LOG.trace("No WOW64 support: {}", e10);
        }
        this._si = si2;
        LOG.debug("Initialized OSNativeSystemInfo");
    }

    public WindowsOSSystemInfo(WinBase.SYSTEM_INFO si2) {
        this._si = si2;
    }

    public int getNumberOfProcessors() {
        return this._si.dwNumberOfProcessors.intValue();
    }
}

